/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture;

public class XWPFPicture {
    protected XWPFParagraph paragraph;
    private CTPicture ctPic;
    private String description;

    public XWPFParagraph getParagraph() {
        return this.paragraph;
    }

    public XWPFPicture(CTPicture ctPic, XWPFParagraph paragraph) {
        this.paragraph = paragraph;
        this.ctPic = ctPic;
        this.description = ctPic.getNvPicPr().getCNvPr().getDescr();
    }

    public void setPictureReference(PackageRelationship rel) {
        this.ctPic.getBlipFill().getBlip().setEmbed(rel.getId());
    }

    public CTPicture getCTPicture() {
        return this.ctPic;
    }

    public XWPFPictureData getPictureData() {
        String blipId = this.ctPic.getBlipFill().getBlip().getEmbed();
        for (POIXMLDocumentPart part : ((POIXMLDocumentPart)((Object)this.paragraph.getPart())).getRelations()) {
            if (!part.getPackageRelationship().getId().equals(blipId)) continue;
            return (XWPFPictureData)part;
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }
}

