/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.utils;

import com.miraisolutions.xlconnect.utils.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatterBuilder;

public class RPOSIXDateTimeFormatter
implements DateTimeFormatter {
    private Map<String, org.joda.time.format.DateTimeFormatter> cache = new HashMap<String, org.joda.time.format.DateTimeFormatter>();

    private org.joda.time.format.DateTimeFormatter getFormatter(String format) {
        if (this.cache.containsKey(format)) {
            return this.cache.get(format);
        }
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        block24: for (int i = 0; i < format.length(); ++i) {
            if (format.charAt(i) == '%' && i + 1 < format.length()) {
                char specifier = format.charAt(++i);
                block0 : switch (specifier) {
                    case '%': {
                        builder.appendLiteral("%");
                        break;
                    }
                    case 'a': {
                        builder.appendDayOfWeekShortText();
                        break;
                    }
                    case 'A': {
                        builder.appendDayOfWeekText();
                        break;
                    }
                    case 'b': {
                        builder.appendMonthOfYearShortText();
                        break;
                    }
                    case 'B': {
                        builder.appendMonthOfYearText();
                        break;
                    }
                    case 'c': {
                        throw new UnsupportedOperationException("%c not yet implemented");
                    }
                    case 'd': {
                        builder.appendDayOfMonth(2);
                        break;
                    }
                    case 'H': {
                        builder.appendHourOfDay(2);
                        break;
                    }
                    case 'I': {
                        builder.appendHourOfHalfday(2);
                        break;
                    }
                    case 'j': {
                        builder.appendDayOfYear(3);
                        break;
                    }
                    case 'm': {
                        builder.appendMonthOfYear(2);
                        break;
                    }
                    case 'M': {
                        builder.appendMinuteOfHour(2);
                        break;
                    }
                    case 'p': {
                        builder.appendHalfdayOfDayText();
                        break;
                    }
                    case 'O': {
                        if (i + 1 >= format.length()) {
                            builder.appendLiteral("%O");
                            break;
                        }
                        switch (format.charAt(++i)) {
                            case 'S': {
                                int n = 3;
                                if (i + 1 < format.length()) {
                                    n = Integer.parseInt(Character.toString(format.charAt(++i)));
                                }
                                builder.appendSecondOfMinute(2);
                                if (n <= 0) continue block24;
                                builder.appendLiteral('.');
                                builder.appendFractionOfSecond(n, n);
                                break block0;
                            }
                            default: {
                                throw new UnsupportedOperationException("%O[dHImMUVwWy] not yet implemented");
                            }
                        }
                    }
                    case 'S': {
                        builder.appendSecondOfMinute(2);
                        break;
                    }
                    case 'y': {
                        builder.appendTwoDigitYear(1968, true);
                        break;
                    }
                    case 'Y': {
                        builder.appendYear(1, 4);
                        break;
                    }
                    case 'z': {
                        builder.appendTimeZoneOffset(null, true, 1, 2);
                        break;
                    }
                    case 'Z': {
                        builder.appendTimeZoneName();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("%" + specifier + " not yet implemented");
                    }
                }
                continue;
            }
            builder.appendLiteral(format.substring(i, i + 1));
        }
        org.joda.time.format.DateTimeFormatter formatter = builder.toFormatter();
        this.cache.put(format, formatter);
        return formatter;
    }

    @Override
    public String format(Date d, String format) {
        StringBuffer sb = new StringBuffer();
        this.getFormatter(format).printTo(sb, (ReadableInstant)new DateTime((Object)d));
        return sb.toString();
    }

    @Override
    public Date parse(String s, String format) {
        return this.getFormatter(format).parseDateTime(s).toDate();
    }
}

