% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xPieplot.r
\name{xPieplot}
\alias{xPieplot}
\title{Function to visualise data frame using pie plots}
\usage{
xPieplot(df, columns, colormap = "ggplot2", pie.radius = NULL,
pie.color = "transparent", pie.color.alpha = 1, pie.thick = 0.1,
legend.title = "", gp = NULL)
}
\arguments{
\item{df}{a data frame}

\item{columns}{a vector containing column names of the input data
frame. These columns are used to draw pie charts}

\item{colormap}{short name for the colormap. It can be one of "jet"
(jet colormap), "bwr" (blue-white-red colormap), "gbr" (green-black-red
colormap), "wyr" (white-yellow-red colormap), "br" (black-red
colormap), "yr" (yellow-red colormap), "wb" (white-black colormap),
"rainbow" (rainbow colormap, that is,
red-yellow-green-cyan-blue-magenta), and "ggplot2" (emulating ggplot2
default color palette). Alternatively, any hyphen-separated HTML color
names, e.g. "lightyellow-orange" (by default), "blue-black-yellow",
"royalblue-white-sandybrown", "darkgreen-white-darkviolet". A list of
standard color names can be found in
\url{http://html-color-codes.info/color-names}}

\item{pie.radius}{the radius of a pie. If NULL, it equals roughly 1/75}

\item{pie.color}{the border color of a pie}

\item{pie.color.alpha}{the 0-1 value specifying transparency of pie
border colors}

\item{pie.thick}{the pie border thickness}

\item{legend.title}{the legend title}

\item{gp}{an existing ggplot object or NULL. It is used for
overlapping}
}
\value{
a ggplot object.
}
\description{
\code{xPieplot} is supposed to visualise data frame using pie plots. It
returns an object of class "ggplot".
}
\examples{
\dontrun{
# Load the library
library(XGR)
}
RData.location <- "http://galahad.well.ox.ac.uk/bigdata"
\dontrun{
gp <- xPieplot(df,
columns=c('dGene','pGene','fGene','nGene','eGene','cGene'),
legend.title='Seeds')
}
}
\seealso{
\code{\link{xPieplot}}
}
