% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xEnrichConciser.r
\name{xEnrichConciser}
\alias{xEnrichConciser}
\title{Function to make enrichment results conciser by removing redundant terms}
\usage{
xEnrichConciser(eTerm, cutoff = c(0.9, 0.5), verbose = T)
}
\arguments{
\item{eTerm}{an object of class "eTerm"}

\item{cutoff}{a cutoff vector used to remove redundant terms. By
default, it has the first element 0.9 and the second element 0.5. It
means, for a term (less significant; called 'B'), if there is a more
significant term (called 'A'), their overlapped members cover at least
90% of the B's members, and also at least 50% of the A's members, then
this term B will be defined as redundant and thus being removed}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to false for no display}
}
\value{
an object of class "eTerm", after redundant terms being removed.
}
\description{
\code{xEnrichConciser} is supposed to make enrichment results conciser
by removing redundant terms. A redundant term (called 'B') is claimed
if its overlapped part (A&B) with a more significant term (called 'A')
meets both criteria: 1) |A&B| > 0.9*|B|; and 2) |A&B| > 0.5*|A|.
}
\note{
none
}
\examples{
\dontrun{
eTerm_concise <- xEnrichConciser(eTerm)
}
}
\seealso{
\code{\link{xEnricherGenes}}, \code{\link{xEnricherSNPs}}
}
