% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Strings.R
\name{Strings}
\alias{Strings}
\alias{strDrop}
\alias{strHead}
\alias{strHeadLower}
\alias{strTail}
\alias{strTake}
\title{Head and Tail functions for Strings.}
\usage{
strHead(s)
strHeadLower(s)
strTail(s)
strTake(s, n)
strDrop(s, n)
}
\arguments{
\item{s}{a string object}

\item{n}{the number of characters to take or drop}
}
\value{
A character vector.
}
\description{
C++ implemetations of convenience functions for strings. All functions but \code{strTake} operate with O(1) memory.

\code{strHead} returns the first character of a string

\code{strHeadLower} returns the first character of a string coerced to lower case

\code{strTail} returns all but the first character of a string

\code{strTake} returns the first \code{n} characters of a string

\code{strDrop} returns all but the first \code{n} characters of a string
}
\details{
A few convenient list operations, tailored to 8-bit-character strings.
}
\section{Note}{

While originally also implemented for performance reasons, the built-in \code{substr} function is usually faster due to the Call-overhead. At least for R 3.x onward the built-in functions should be preferred when performance is an issue. See the vignette for details.
}
\examples{
strHead("Gnu")
strHeadLower("Gnu")
strTail("Gnu")
strTake("Gnus and Gnats",3)
strDrop("Gnus and Gnats",9)
}

