% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/userInfo.R
\name{userInfo}
\alias{userInfo}
\title{provides general information about a Wikipedia user}
\usage{
userInfo(user.name = NULL, domain = "en",
  usprop = "groups|implicitgroups|rights|editcount|registration|emailable|gender")
}
\arguments{
\item{user.name}{a character value for the name of a user}

\item{domain}{a character value providing the language of the wikipedia page.The default value is "en" for "english language".}

\item{usprop}{What pieces of information to include (separate with '|'):
\itemize{
\item{\code{groups}}{: lists all the groups the user(s) belongs to}
\item{\code{implicitgroups}}{: lists all the groups a user is automatically a member of}
\item{\code{rights}}{: lists all the rights the user(s) has}
\item{\code{editcount}}{: adds the user's edit count}
\item{\code{registration}}{: adds the user's registration timestamp}
\item{\code{emailable}}{: tags if the user can and wants to receive email through [[Special:Emailuser]]}
\item{\code{gender}}{: tags the gender of the user. Returns "male", "female", or "unknown"}
}
Default: groups|implicitgroups|rights|editcount|registration|emailable|gender}
}
\value{
an object of class \code{userInfoClass} containing:
\itemize{
\item{\code{call}}{ the command line}
\item{\code{rights}}{ only if asked: a vector of rights. If not asked, this item does not exist.}
\item{\code{groups}}{ only if asked: a vector of groups names. If not asked, this item does not exist.}
\item{\code{implicitgroups}}{ only if asked: a vector of implicit groups names. If not asked, this item does not exist.}
\item{\code{info}}{ a data frame containing the other asked properties of user (at least userid and name). }
\item{\code{testWikiUser}}{ A list of three elements.
 The first is \code{takeOnlyFirst}, a boolean indicating if the class of \code{user.name} parameter is invalid,
 for example vector, list, matrix..., and in that case, the only the first element is considered.
   The second element is \code{test}, an integer with value:
   \itemize{
   \item{4}{ for invalid domain,}
   \item{3}{ for an empty parameter user,}
   \item{2}{ when Wikipedia does not have an user with this exact name,}
   \item{0}{ for valid existing user. }
   }
 The last element, \code{warnMessage}, is a vector of warning messages.
 }
}
}
\description{
provides general information about a specific Wikipedia user
}
\details{
This function uses the MediaWiki API query syntax: "list=users".
For more details, see \url{https://www.mediawiki.org/wiki/API:Users}
}
\examples{
\dontrun{
LouiseInfo <- userContribs(user.name = "Louise", domain = "en")
LouiseInfo
bobInfo <- userInfo(user.name = "bob", domain = "en")
bobInfo
## try a user that does not exist (at the moment of the redaction of this help page)
userInfo(user.name="Louise Baschet", domain ="fr")
}
}
\author{
Avner Bar-Hen, Louise Baschet, Francois-Xavier Jollois, Jeremie Riou
}

