% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus.R
\name{corpus_page_data}
\alias{corpus_page_data}
\title{Adding page data to a page corpus}
\usage{
corpus_page_data(method, x, selection = c("nbLinks", "nbContrib",
  "nbRevisions", "percentAnon", "percent10"), domain = "fr")
}
\arguments{
\item{method}{The method employed to get data into the corpus. \describe{
 \item{variables}{For each page of the corpus, return variables specified in selection}
}}

\item{x}{A character vector created with \code{\link{corpus_page_create}}}

\item{selection}{A character vector giving all the data variables to get in the corpus : \describe{
 \item{nbLinks}{Number of links in the page}
 \item{nbContrib}{Number of contributors who have edited the page at least once}
 \item{nbRevisions}{Number of revisions of the page}
 \item{percentAnon}{Percentage of anonymous contributions}
 \item{percent10}{Percentage of the text due to the 10 \% first contributor}
}}

\item{domain}{The domain where the wiki is located}
}
\value{
A data-frame.
}
\description{
Adding page data to a page corpus
}
\examples{
# Creating a page corpus with 3 randomly selected page
corpus <- corpus_page_create('random',3)
corpus <- corpus_page_data("variables",corpus)
}
\seealso{
Other corpus functions: \code{\link{corpus_contrib_create}},
  \code{\link{corpus_contrib_data}},
  \code{\link{corpus_contrib_select}},
  \code{\link{corpus_page_create}}
}

