% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webpower.R
\name{wp.mc.chisq.diff}
\alias{wp.mc.chisq.diff}
\title{Statistical Power Analysis for SEM Based on Chi-square Difference Test}
\usage{
wp.mc.chisq.diff(full.model.pop, full.model, 
reduced.model, N=100, R=1000, alpha=0.05)
}
\arguments{
\item{full.model.pop}{Full model (under the alternative hypothesis) with population parameters.}
\item{full.model}{Full model (under the alternative hypothesis) lavaan specification.}
\item{reduced.model}{Reduced model (under the null hypothesis) lavaan specification.}

\item{N}{Sample size.}

\item{R}{Number of Monte Carlo replications.}

\item{alpha}{significance level chosed for the test. It equals 0.05 by default.}
}
\value{
An object of the power analysis.
\item{power}{Statistical power.}
\item{df}{Degrees of freedom}
\item{chi.diff}{Chi-square differences between the reduced model and the full model}
}
\description{
This function is for SEM power analysis based on the chi-square difference test.
}
\examples{
\donttest{
full.model.pop <-'
y1 ~ 0.4*x
y2 ~ 0.5*x + 0.2*y1
y3 ~ 0.4*x
y4 ~ 0.4*y1 + 0.4*y2 + 0.4*y3
y1 ~~ 0.84*y1
y2 ~~ 0.61*y2
y3 ~~ 0.84*y3
y4 ~~ 0.27*y4
'

full.model <-'
y1 ~ x
y2 ~ x + y1
y3 ~ x
y4 ~ y1 + y2 + y3
'

reduced.model <-'
y1 ~ x
y2 ~ x 
y3 ~ x
y4 ~ y1 + y3
'

wp.mc.chisq.diff(full.model.pop, full.model, reduced.model)
}

}
\references{
Demidenko, E. (2007). Sample size determination for logistic regression revisited. Statistics in medicine, 26(18), 3385-3397.

Zhang, Z., & Yuan, K.-H. (2018). Practical Statistical Power Analysis Using Webpower and R (Eds). Granger, IN: ISDSA Press.
}
