% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptiveQuad.R
\name{mix}
\alias{mix}
\title{Survey Weighted Mixed-Effects Models}
\usage{
mix(formula, data, weights, nQuad = 13L, run = TRUE, verbose = TRUE,
  acc0 = 120, keepAdapting = FALSE, start = NULL, fast = FALSE)
}
\arguments{
\item{formula}{a formula object in the style of lme4 that creates the model.}

\item{data}{a data frame containing the raw data for the model.}

\item{weights}{a character vector of weight variables found in data frame.}

\item{nQuad}{an integer  number of quadrature point to evaluate on. See notes for guidelines.}

\item{run}{logical, true runs the model, false provides partial output for debug or testing.}

\item{verbose}{boolean, default False, set to TRUE to print results of intermediate steps}

\item{acc0}{integer, the precision of mpfr, default 120}

\item{keepAdapting}{logical, set to TRUE when the adaptive quadrature should adapt after every Newton step. Defaults to TRUE. 
False should be used rarely for faster (but less accurate) results.}

\item{start}{numeric vector representing the point at which the model should start optimization; takes the shape of c(coef, vars) 
from results (see help).}

\item{fast}{logical, use  c++ function for faster result. Defaults to True.}
}
\value{
object of class WeMixResults
This is a list with objects: 
lnlf - function, the likelihood function 
lnl - numeric, the logliklihood of the model 
coef - numeric vector, the estimated coefficients of the model 
vars- numeric vector, the variances
call - the original call used 
levels - integer, the number of levels in the model 
ICC - numeric, the Intraclass Correlation Coefficient 
CMEAN  - function the conditional mode function that can be called with par and omega to get the conditional mode of the likelihood function
CMODE - function the conditional mean function that can be called with par and omega to get the conditional mean of the likelihood function
Hessian - the second derivative of the likelihood function
}
\description{
Implements a survey weighted mixed-effects model using the provided formula.
}
\details{
Uses adaptive quadrature following the method in Statas's GLAMMM. For additional details, see main vignette 
"WeightedMixedModels.pdf"  which provides extensive examples as well as a description of the mathematical 
basis of the estimation procedure. The main specification also shows comparisons to model specifications in other
common software. 

Notes: 
\itemize{
\item Standard errors of random effect variances are estimated by the Sandwich Method, see main vingette for details. 
\item To see the function that is maximized in the estimation of this model see the section on "Model fitting" in the main vingette.
\item When all weights above the individual level are one, this is similar to a lmer and you should use lme4 because it is much faster.
\item Starting coefficients are not provided they are estimated using lme4. 
\item When the variance of a random effect is very low (<.1) we don't estimate it because very low variances create problems with  numerical evaluation.
 In these cases, consider re estimating without that RE.
 \item The model is estimated by maximum likelihood estimation, restricted maximum liklihood (REML) is not available 
\item To chose number of quadrature points a balance is needed between accuracy and speed- estimation time increases quadratically 
with the number of points chosen. Additionaly an odd number of points is traditionaly used. We recommend starting at 13 and increasing 
or decreasing as needed. 
}
}
\examples{
library(WeMix)
library(EdSurvey)
naep <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package="NAEPprimer"))
naepData <- getData(naep,varnames=c("lep","origwt","smsrswt","scrpsu","dsex","mrpcm1"))[1:200,]
me1 <- mix(mrpcm1 ~  lep+ dsex + (1|scrpsu), data=naepData, 
   weights=c("origwt", "smsrswt"), nQuad=7, verbose=FALSE, fast=TRUE,run=TRUE)
}
\author{
Paul Bailey, Claire Kelley, and Trang Nguyen
}
