% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/astro_anchor.R
\name{astro_anchor}
\alias{astro_anchor}
\title{Anchor proxy record to an astronomical solution}
\usage{
astro_anchor(
  astro_solution = NULL,
  proxy_signal = NULL,
  proxy_min_or_max = "max",
  clip_astrosolution = FALSE,
  astrosolution_min_or_max = "max",
  clip_high = NULL,
  clip_low = NULL,
  extract_astrosolution = FALSE,
  astro_period_up = 1.2,
  astro_period_down = 0.8,
  astro_period_cycle = NULL,
  extract_proxy_signal = FALSE,
  proxy_period_up = 1.2,
  proxy_period_down = 0.8,
  proxy_period_cycle = NULL,
  pts = 3,
  verbose = FALSE,
  time_dir = TRUE,
  genplot = FALSE
)
}
\arguments{
\item{astro_solution}{Input is an astronomical solution which the proxy record will be anchored to,
the input should be a matrix or data frame with the first column being
age and the second column should be a insolation/angle/value}

\item{proxy_signal}{Input is the proxy data set which will
be anchored to an astronomical solution, the input should be a matrix or
data frame with the first column being  depth/time and the second column should be a proxy value.
For the best results either the astronomical components need to be pre-extracted
before anchoring. This means that a filtering/cycle extracting need to be applied to
the input data or the  extract_proxy_signal option needs to be set to TRUE.}

\item{proxy_min_or_max}{Tune proxy maxima or minima to the astronomical solution \code{Default="max"}.}

\item{clip_astrosolution}{Clip the astronomical solution \code{Default=FALSE}.}

\item{astrosolution_min_or_max}{Tune to maximum or minimum values of
the astronomical solution \code{Default="max"}}

\item{clip_high}{Upper value to clip to.}

\item{clip_low}{Lower value to clip to.}

\item{extract_astrosolution}{Extract a certain astronomical cycle/component from a
astronomical solution prior to anchoring \code{Default=FALSE}.}

\item{astro_period_up}{Specifies the upper period of the astronomical cycle which is
extracted from an astronomical solution. The astro_period_up is a
factor with which the astronomical component is multiplied by.  \code{Default=1.2}}

\item{astro_period_down}{Specified the lower period of the astronomical cycle which is
extracted from an astronomical solution. The astro_period_down value is a
factor with which the astronomical component is multiplied by. \code{Default=0.8}}

\item{astro_period_cycle}{Period (in kyr) of the to be extracted astronomical component
from the astronomical solution.}

\item{extract_proxy_signal}{Extract a certain astronomical cycle/component from a
proxy signal  \code{Default=FALSE}.}

\item{proxy_period_up}{Specifies the upper period of the astronomical cycle to be extracted
from the proxy record. The upper bound value is a factor with which the
(proxy_period_cycle) value is multiplied by. \code{Default=1.2}.}

\item{proxy_period_down}{Specifies the upper period of the astronomical cycle to be
extracted from the proxy record. The lower bound value is a factor with
which the astronomical component (proxy_period_cycle) value is multiplied by. \code{Default=0.8}.}

\item{proxy_period_cycle}{Period in kyr of the astronomical cycle/component which is to be extracted
from the proxy record.}

\item{pts}{The pts parameter specifies how many points to the left/right up/down the peak detect algorithm goes in detecting
a peak. The peak detecting algorithm works by comparing the values left/right up/down of it, if the values are both higher or lower
then the value a peak. To deal with error produced by this algorithm the pts parameter can be changed which can
aid in peak detection. Usually increasing the pts parameter means more peak certainty, however it also means that minor peaks might not be
picked up by the algorithm \code{Default=3}}

\item{verbose}{print text \code{Default=FALSE} set verbose to TRUE to allow for anchoring using text feedback commands}

\item{time_dir}{The direction of the proxy record which is assumed for tuning if time increases with increasing depth/time values
(e.g. bore hole data which gets older with increasing depth ) then time_dir should be set to TRUE
if time decreases with depth/time values (eg stratigraphic logs where 0m is the bottom of the section)
then time_dir should be set to FALSE \code{time_dir=TRUE}}

\item{genplot}{Generate plot \code{Default="FALSE"}}
}
\value{
The output is a matrix with the 4 columns.
The first column is the depth/time of the proxy tie-point.
The second column is the time value of the astronomical solution tie-point.
The third column is the proxy value of the proxy tie-point.
The fourth column is the proxy/insolation value of the astronomical solution  tie-point.
If genplot is set to true then at plot of the of the achored points will be plotted
}
\description{
Anchor the extracted signal to an astronomical solution using a GUI.
The \code{\link{astro_anchor}} function allows one to tie minima or maxima in the proxy record
to minima or maxima in an astronomical solution.
By tying the proxy record to an astronomical solution one will generate tie-points which
can be used to generate a astrochronological age-model
As minima or maxima in the proxy record are tied to minima or maxima in an astronomical solution it is
important to provide input which has clearly definable minima and maxima.
As such input should be of a "sinusoidal" nature otherwise the \code{extract_astrosolution=TRUE}
and/or \code{extract_proxy_signal=TRUE} options need to be set to TRUE to create sinusoidal signals.

Astronomical solutions option are:
\itemize{
    \item La2004 Eccentricity solution available via the \link[astrochron]{getLaskar} function or downloadable via \url{http://vo.imcce.fr/insola/earth/online/earth/earth.html}
   \item La2004 Obliquity solution available via the \link[astrochron]{getLaskar} function or downloadable via \url{http://vo.imcce.fr/insola/earth/online/earth/earth.html}
   \item La2004 Precession solution available via the \link[astrochron]{getLaskar} function or downloadable via \url{http://vo.imcce.fr/insola/earth/online/earth/earth.html}
   \item La2010a Eccentricity solution available via the \link[astrochron]{getLaskar}function or downloadable via \url{http://vo.imcce.fr/insola/earth/online/earth/earth.html}
   \item La2010a Obliquity solution downloadable via the \url{http://vo.imcce.fr/insola/earth/online/earth/earth.html}
   \item La2010a Precession solution downloadable via \url{http://vo.imcce.fr/insola/earth/online/earth/earth.html}
   \item La2010b Eccentricity solution available via the \link[astrochron]{getLaskar} function or downloadable via \url{http://vo.imcce.fr/insola/earth/online/earth/earth.html}
   \item La2010b Obliquity solution downloadable via \url{http://vo.imcce.fr/insola/earth/online/earth/earth.html}
   \item La2010b Precession solution downloadable via \url{http://vo.imcce.fr/insola/earth/online/earth/earth.html}
   \item La2010c Eccentricity solution available via the \link[astrochron]{getLaskar} function or downloadable via \url{http://vo.imcce.fr/insola/earth/online/earth/earth.html}
   \item La2010c Obliquity solution downloadable via \url{http://vo.imcce.fr/insola/earth/online/earth/earth.html}
   \item La2010c Precession solution downloadable via \url{http://vo.imcce.fr/insola/earth/online/earth/earth.html}
   \item La2010d Eccentricity solution available via the \link[astrochron]{getLaskar} function or downloadable via \url{http://vo.imcce.fr/insola/earth/online/earth/earth.html}
   \item La2010d Obliquity solution downloadable via \url{http://vo.imcce.fr/insola/earth/online/earth/earth.html}
   \item La2010d Precession solution downloadable via \url{http://vo.imcce.fr/insola/earth/online/earth/earth.html}
   \item La2011 Eccentricity solution available via the \link[astrochron]{getLaskar} function or downloadable via \url{http://vo.imcce.fr/insola/earth/online/earth/earth.html}
   \item ZB17a Eccentricity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB17a Obliquity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB17b Eccentricity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB17b Obliquity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB17c Eccentricity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB17c Obliquity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB17d Eccentricity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB17d Obliquity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB17e Eccentricity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB17e Obliquity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB17f Eccentricity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB17f Obliquity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB17h Eccentricity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB17h Obliquity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB17i Eccentricity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB17i Obliquity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB17j Eccentricity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB17j Obliquity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB17k Eccentricity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB17k Obliquity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB17p Eccentricity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB17p Obliquity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB18a Eccentricity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB18a Obliquity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB20a Eccentricity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB20a Obliquity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB20b Eccentricity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB20b Obliquity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB20c Eccentricity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB20c Obliquity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB20d Eccentricity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item ZB20d Obliquity solution downloadable via \url{https://www.soest.hawaii.edu/oceanography/faculty/zeebe_files/Astro.html}
   \item 405kyr eccentricity 405 metronome can be generated using the formula:\cr
     e405=0.027558-0.010739*cos(0.0118+2(pi)*(t/405000)) (laskar et al., 2004 & laskar 2020)
   \item 173kyr obliquity  metronome can be generated using using the formula:\cr
    es3-s6(t) = 0.144*cos(1.961+2(pi)*(t/172800) (laskar et al., 2004 & laskar 2020)
   \item An etp model using the \link[astrochron]{etp} function of the 'astrochron' R package
   }
}
\examples{
\donttest{
# Use the grey_track example tracking points to anchor the grey scale data set
# of Zeeden et al., (2013) to the p-0.5t la2004 solution

grey_wt <-
 analyze_wavelet(
   data = grey,
   dj = 1/200,
   lowerPeriod = 0.02,
   upperPeriod = 256,
   verbose = FALSE,
   omega_nr = 8
 )
#Use the pre-tracked grey_track curve which traced the precession cycle
grey_track <- completed_series(
 wavelet = grey_wt,
 tracked_curve  = grey_track,
 period_up  = 1.25,
 period_down  = 0.75,
 extrapolate = TRUE,
genplot = FALSE
)
# Extract precession, obliquity and eccentricity to create a synthetic insolation curve

grey_prec <- extract_signal(
tracked_cycle_curve = grey_track[,c(1,2)],
wavelet = grey_wt,
period_up = 1.2,
period_down = 0.8,
add_mean = FALSE,
tracked_cycle_period = 22,
extract_cycle = 22,
tune = FALSE,
plot_residual = FALSE
)

grey_obl <- extract_signal(
 tracked_cycle_curve = grey_track[,c(1,2)],
 wavelet = grey_wt,
 period_up = 1.2,
 period_down = 0.8,
 add_mean = FALSE,
 tracked_cycle_period = 22,
 extract_cycle = 110,
 tune = FALSE,
 plot_residual = FALSE
)

grey_ecc <- extract_signal(
 tracked_cycle_curve = grey_track[,c(1,2)],
 wavelet = grey_wt,
 period_up = 1.25,
 period_down = 0.75,
 add_mean = FALSE,
 tracked_cycle_period = 22,
 extract_cycle = 40.8,
 tune = FALSE,
 plot_residual = FALSE
)

insolation_extract <- cbind(grey_ecc[,1],grey_prec[,2]+grey_obl[,2]+grey_ecc[,2]+mean(grey[,2]))
insolation_extract <- as.data.frame(insolation_extract)
insolation_extract_mins <- min_detect(insolation_extract,pts=3)

#use the astrosignal_example to tune to which is an \cr
# ETP solution (p-0.5t la2004 solution)
astrosignal_example <- na.omit(astrosignal_example)
astrosignal_example[,2] <- -1*astrosignal_example[,2]
astrosignal <- as.data.frame(astrosignal_example)

#anchor the synthetic insolation curve extracted from the grey scale record to the insolation curve.

anchor_pts <- astro_anchor(
astro_solution = astrosignal,
proxy_signal = insolation_extract,
proxy_min_or_max = "min",
clip_astrosolution = FALSE,
astrosolution_min_or_max = "min",
clip_high = NULL,
clip_low = NULL,
extract_astrosolution  = FALSE,
astro_period_up  = NULL,
astro_period_down  = NULL,
astro_period_cycle  = NULL,
extract_proxy_signal  = FALSE,
proxy_period_up  = NULL,
proxy_period_down  = NULL,
proxy_period_cycle  = NULL,
pts=3,
verbose=FALSE, #set verbose to TRUE to allow for anchoring using text feedback commands
genplot=FALSE
)}

}
\references{
J. Laskar, P. Robutel, F. Joutel, M. Gastineau, A.C.M. Correia, and B. Levrard, B., 2004,
A long term numerical solution for the insolation quantities of the Earth: Astron. Astrophys.,
Volume 428, 261-285. <\doi{doi:10.1051/0004-6361:20041335}> \cr

Laskar, J., Fienga, A., Gastineau, M., Manche, H., 2011a,
La2010: A new orbital solution for the long-term motion of the Earth: Astron. Astrophys.,
Volume 532, A89 <\doi{doi:10.1051/0004-6361/201116836}> \cr

Laskar, J., Gastineau, M., Delisle, J.-B., Farres, A., Fienga, A.:
2011b, Strong chaos induced by close encounters with Ceres and Vesta, Astron: Astrophys.,
Volume 532, L4.  <\doi{doi.org/10.1051/0004-6361/201117504}>\cr

J. Laskar,Chapter 4 - Astrochronology,Editor(s): Felix M. Gradstein, James G. Ogg, Mark D. Schmitz, Gabi M. Ogg,Geologic Time Scale 2020,Elsevier,2020,Pages 139-158,ISBN 9780128243602,
<\doi{doi:10.1016/B978-0-12-824360-2.00004-8}> or \url{https://www.sciencedirect.com/science/article/pii/B9780128243602000048} \cr

Zeebe, R. E. and Lourens, L. J.
Geologically constrained astronomical solutions for the Cenozoic era,
Earth and Planetary Science Letters, 2022 <\doi{doi:10.1016/j.epsl.2022.117595}>\cr

Richard E. Zeebe Lucas J. Lourens ,Solar System chaos and the Paleocene–Eocene boundary age constrained by geology and astronomy.Science365,926-929(2019)
<\doi{doi:10.1126/science.aax0612}>\cr

Zeebe, Richard E. "Numerical solutions for the orbital motion of the Solar System over the past 100 Myr: limits and new results."
The Astronomical Journal 154, no. 5 (2017): 193. <\doi{doi:10.3847/1538-3881/aa8cce}> \cr

Stephen R. Meyers,Cyclostratigraphy and the problem of astrochronologic testing,
Earth-Science Reviews,Volume 190,2019,Pages 190-223,ISSN 0012-8252
<\doi{doi:10.1016/j.earscirev.2018.11.015}>
}
