% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistributionPlot.R
\name{PlotDistCountNormal}
\alias{PlotDistCountNormal}
\title{Plot distribution details as a histogram plus matching normal}
\usage{
PlotDistCountNormal(frm, xvar, title, ..., binWidth = c())
}
\arguments{
\item{frm}{data frame to get values from}

\item{xvar}{name of the independent (input or model) column in frame}

\item{title}{title to place on plot}

\item{...}{no unarmed argument, added to force named binding of later arguments.}

\item{binWidth}{width of histogram bins}
}
\description{
Compares empirical data to a normal distribution with the same mean and standard deviation.
}
\details{
Plots the histograms of the empirical distribution and of the matching normal distribution.
Also plots the mean and plus/minus one standard deviation.

Bin width for the histogram is calculated automatically to yield approximately 50 bins across the
range of the data, unless the \code{binWidth} argument is explicitly passed in. \code{binWidth} is reported
in the subtitle of the plot.
}
\examples{

set.seed(52523)
d <- data.frame(wt=100*rnorm(100))
PlotDistCountNormal(d,'wt','example')

}
