% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_amplification_efficiency.R
\name{apply_amplification_efficiency}
\alias{apply_amplification_efficiency}
\title{Apply PCR amplification efficiency estimation to a data.frame}
\usage{
apply_amplification_efficiency(standard_curves)
}
\arguments{
\item{standard_curves}{A data.frame giving the target name, serial diluted concentration of target nucleic acid,
and Ct value from a standard curve assay. Must follow the \code{template_WES_standard_curve} standardized format.}
}
\value{
A data.frame containing the mean, and low and high of the 95\% confidence interval of the percentile
amplification efficiency for each target name.
}
\description{
This function applies the \code{est_amplification_efficiency()} function to a data.frame object which follows the
standardized format shown in the \code{template_WES_standard_curve} data set.
}
\examples{
apply_amplification_efficiency(template_WES_standard_curve)

}
