% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{fig.dwt.vt}
\alias{fig.dwt.vt}
\title{Plot function: Variance structure before and after variance transformation}
\usage{
fig.dwt.vt(dwt.data)
}
\arguments{
\item{dwt.data}{Output data from variance transformation function}
}
\value{
A plot with variance structure before and after variance transformation.
}
\description{
Plot function: Variance structure before and after variance transformation
}
\examples{
data("data.HL")
data("data.SW1")

# variance transfrom
dwt.SW1 <- dwt.vt(data.SW1[[1]],
  wf = "d4", J = 7, method = "dwt",
  pad = "zero", boundary = "periodic", cov.opt = "auto"
)

# plot
fig1 <- fig.dwt.vt(dwt.SW1)
fig1

# variance transfrom
dwt.HL <- dwt.vt(data.HL[[1]],
  wf = "d4", J = 7, method = "dwt",
  pad = "zero", boundary = "periodic", cov.opt = "auto"
)

# plot
fig2 <- fig.dwt.vt(dwt.HL)
fig2
}
