% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculator_f.R
\name{cond_dirichlet}
\alias{cond_dirichlet}
\title{Calculate conditional dirichlet values}
\usage{
cond_dirichlet(alpha, i, xi, full_output = FALSE)
}
\arguments{
\item{alpha}{mean vector}

\item{i}{index of the known parameter (1-based index)}

\item{xi}{known value of the i-th parameter (should be >0)}

\item{full_output}{boolean indicating whether to return the full list of parameters}
}
\value{
List of length 2, one with new mu and other with covariance parameters
}
\description{
Calculate conditional dirichlet values
}
\details{
Function to compute conditional dirichlet values
}
\examples{
alpha <- c(2, 3, 4)
i <- 2  # Index of the known parameter
xi <- 0.5  # Known value of the second parameter

# Compute the conditional alpha parameters with full output
cond_dirichlet(alpha, i, xi, full_output = TRUE)
}
