% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noaa.r
\name{noaa}
\alias{noaa}
\title{Downloads NOAA CO-OPS tide data}
\usage{
noaa(begindate = "begindate", enddate = "enddate", station = "8467150",
met = FALSE, units = "meters", datum = "MHW", interval = "HL", time = "GMT", 
continuous = TRUE)
}
\arguments{
\item{begindate}{first day of data to download. Format must be YYYYMMDD. If 
left unspecified, the first complete day of data will be used.}

\item{enddate}{final day of data to download. Format must be YYYYMMDD. If left 
unspecified, the last complete day of data will be used.}

\item{station}{station number, found on the NOAA Tides and Currents website 
(https://www.tidesandcurrents.noaa.gov/stations.html?type=Water+Levels).
Station numbers can be numeric or a character string (necessary if first 
character is a zero). Default station is Bridgeport, CT.}

\item{met}{whether meteorological data should be returned. This value can be 'TRUE' or 
'FALSE'; if 'TRUE', all ancillary parameters are returned. At present, this only 
works with 6-minute and hourly data}

\item{units}{can be 'feet' or 'meters'. Default is 'meters'}

\item{datum}{vertical reference datum, set to 'MHW' by default. Can be 'station', 'NAVD', 
'MLLW', 'MLW', 'MSL', 'MTL', 'MHW', 'MHHW', or 'IGLD' (some datums are not available 
at some sites)}

\item{interval}{sets measurement interval; can be 'HL' (default), '6 minute', 'hourly', or 'monthly'.}

\item{time}{can be 'LST', 'GMT', or 'LST/LDT'. Not all time zones are available for all data. 
GMT appears to have wider availability than LST, so it is the default.}

\item{continuous}{determines whether a continuous time series is produced, with lengthy gaps 
in data filled in with NAs. By default, this is \code{FALSE}. This option only applies 
to data at evenly spaced intervals (i.e., \code{6 minute} or \code{hourly})}
}
\value{
dataset a dataframe with water levels, associated time stamps, a station ID column, 
and tide type (if interval is set to \code{HL}). The NOAA CO-OPS website has many odd data 
availabilty problems. Some data are not available in all time intervals or time zones.
}
\description{
Scrapes water level data (and other measurements) from NOAA CO-OPS website. NOAA's site limits the time period for data downloads, but these constraints are avoided by `noaa()`. Requires 
internet connection and curl (check availablility using `Sys.which("curl")`).
}
\details{
Download water level and other data from NOAA CO-OPS website.
}
\examples{
\dontrun{
# Example requires an internet connection
bport2013 <- noaa(begindate = 20130101, enddate = 20131231, 
  station = "8467150", interval = "6 minute")

test2.1 <- noaa("20100101", "20120101", interval = "hourly") 
test2.2 <- noaa("20100101", "20120101", interval = "hourly", continuous = TRUE) 
nrow(test2.1) # includes data on NOAA site (incomplete record)
nrow(test2.2) # fills gaps with NAs 
test2.3 <- noaa("20100101", "20120101", interval = "hourly", met = TRUE) 
}
}
