##' Graphical visualization tools for complex observational data (VizOR).
##' Package functionality includes individual- and aggregate-level graphics
##' depicting patterns of treatment and response in patient registries, and
##' a graphical tool for identifying potential for confounding in analyses
##' of observational data.
##' 
##' \tabular{ll}{
##' Package: \tab VizOR\cr
##' Type: \tab Package\cr
##' Version: \tab 0.7-9\cr
##' Date: \tab 2013-11-14\cr
##' License: \tab GPL (>= 2)\cr
##' LazyLoad: \tab yes\cr
##' }
##' TODO: Provide a general introduction to the package, including an orientation
##' to its most important functions.
##' 
##' @name VizOR-package
##' @aliases VizOR-package VizOR
##' @docType package
##' @author
##'   Drew Griffin Levy, PhD
##'   \cr Senior Medical Science Director
##'   \cr Genentech, Inc.
##'   \cr Evidence Science & Innovation | US Medical Affairs
##'   \cr \email{levy.drew@@gene.com}
##' @author
##'   David C. Norris, MD
##'   \cr David Norris Consulting, LLC
##'   \cr \email{david@@UnusualSolutionsThatWork.com}
##' @seealso \code{\link[Hmisc:Overview]{Hmisc}}
##'   \code{\link[rms:rms]{rms}}
##' @keywords package
##' @import lattice
##' @import grid
##' @import stats
##' @import rms
##' 
NULL
##' Documentation for included dataset \code{vlbw}
##'
##' Data on 671 infants with very low (<1600 grams) birth weight from
##' 1981-87 were collected at Duke University Medical Center by
##' Dr. Michael O'Shea.
##'
##' @name vlbw
##' @docType data
##' @title Data on 671 very low birth weight infants
##' @references O'Shea M, Savitz DA, Hage ML, Feinstein KA: Prenatal
##' events and the risk of subependymal / intraventricular haemorrhage
##' in very low birth weight neonates. \emph{Paediatric and Perinatal
##' Epidemiology} 1992;6:352-362.
##' @format A data frame containing 32 observations on 671 infants.
##' @source \url{http://biostat.mc.vanderbilt.edu/wiki/Main/DataSets}
NULL
