% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetData.R
\name{GetData}
\alias{GetData}
\title{Reads Data from the HMD and HFD into R}
\usage{
GetData(country, user, pw_HMD, pw_HFD)
}
\arguments{
\item{country}{Code of the selected country. The code must be one of the country codes of HMD and HFD.}

\item{user}{email address of the user, used at registration with the HMD and HFD. It
is assumed that the same email address is used for both HMD and HFD.}

\item{pw_HMD}{Password to access HMD, provided at registration.}

\item{pw_HFD}{Password to access HFD, provided at registration}
}
\value{
\item{data_raw}{A list object with four elements:}
\item{country}{Country}
\item{LTf}{Life table for female population for all years available in the HMD}
\item{LTm}{Life table for male population for all years available in the HMD}
\item{fert_rates}{Conditional fertility rates for all years available in the HFD}
}
\description{
Reads data from the HMD and HFD into R. The function uses the readHMDweb() and the readHFDweb() functions of the HMDHFDplus package.
}
\examples{


\dontrun{
data_raw <- GetData(country="USA",user,pw_HMD,pw_HFD)
}

}
