% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primality.R
\name{18. Probabilistic primality tests}
\alias{18. Probabilistic primality tests}
\alias{is.primeF}
\alias{is.primeF.default}
\alias{is.primeF.numeric}
\alias{is.primeF.vli}
\alias{is.primeMR}
\alias{is.primeMR.default}
\alias{is.primeMR.numeric}
\alias{is.primeMR.vli}
\alias{is.primeSS}
\alias{is.primeSS.default}
\alias{is.primeSS.numeric}
\alias{is.primeSS.vli}
\alias{is.prime}
\title{Probabilistic Primality Tests for vli Objects}
\usage{
is.primeF(x, iter = 10)

\method{is.primeF}{default}(x, iter = 10)

\method{is.primeF}{numeric}(x, iter = 10)

\method{is.primeF}{vli}(x, iter = 10)

is.primeMR(x, iter = 10)

\method{is.primeMR}{default}(x, iter = 10)

\method{is.primeMR}{numeric}(x, iter = 10)

\method{is.primeMR}{vli}(x, iter = 10)

is.primeSS(x, iter = 10)

\method{is.primeSS}{default}(x, iter = 10)

\method{is.primeSS}{numeric}(x, iter = 10)

\method{is.primeSS}{vli}(x, iter = 10)

is.prime(x, iter = 10, test = "MR")
}
\arguments{
\item{x}{number to be tested; object of class vli or 32 bits integer}

\item{iter}{number of iterations; numeric}

\item{test}{chosen test: "F" for the Fermat Test, "SS" for the Solovay-Strassen Test or "MR" (by default) for the Miller-Rabin Test; character}
}
\value{
boolean:
if the test determines that the given number is prime it returns \code{TRUE}
if the test determines that the given number is composite it returns \code{FALSE}
}
\description{
Functions to compute different probabilistic primality tests for vli (Very Large Integer) objects.

The function \code{is.primeF} computes the Fermat Primality Test.

The function \code{is.primeMR} computes the Miller-Rabin Primality Test.

The function \code{is.primeSS} computes the Solovay-Strassen Primality Test.

The function \code{is.prime} is a general function that computes the test specified in the \code{test} argument.
}
\details{
Probabilistic primality tests are algorithms that determine if an integer is prime or composite. They are not deterministic tests so there is a probability of error (it is never reported a prime number as composite, but it is possible for a composite number to be reported as prime). This probability of error can be calculated and reduced as much as we want by increasing the number of iterations of the test.

Each test is different and therefore they have different computational efficiency and one could be better than other for testing some numbers. However, the Miller-Rabin test is the most accurated of all three and, because of that, it is the test chosen by default in every function that needs primality testing in the present package.

The Fermat Primality Test detects composite numbers by using the Fermat's Little Theorem, which says that, if \code{p} is prime, for any integer \code{a} satisfaying \code{gcd(a, p) = 1} we have that \code{a^(p-1) = 1 }(\code{mod p}).
Each iteration randomly pick an integer \code{a}. The more iterations are computed, the greater probability to find an \code{a} that does not verify such conditions and, therefore, reveals that \code{p} is composite. However, there are some composite numbers \code{p} that have the property that \code{a^(p-1) = 1 }(\code{mod p}) for every \code{a} coprime to \code{p}. These numbers are called Carmichael numbers or Fermat pseudoprimes, and it is not possible for the Fermat Test to detect that they are composite numbers. But there are only 105212 such numbers up to \code{10^15} (approximately 1 Carmichael number per each 10.000.000.000 integer numbers). The first five are: 561, 1105, 1729, 2465 and 2821.

As a conclusion, we can say that if the chosen \code{x} number is prime, the Fermat test returns \code{TRUE}. If it is an odd composite (but not a Carmichael number), it returns \code{FALSE} with probability at least \code{1/2^k}, where \code{k} is the number of computed iterations.

The Miller-Rabin Primality Test is a more sophisticated version of the Fermat test. If the chosen \code{x} number is prime, the test returns \code{TRUE}. If \code{x} is an odd composite the algorithm returns \code{TRUE} (that is, it fails) with probability less than \code{1/4^k}, where \code{k} is the number of computed iterations. In cases of very big numbers, the probability is even smaller.

The Solovay-Strassen test is based in a known algebraic property of the Jacobi symbol. The probabily of failure is also less than \code{1/2^k}, where \code{k} is the number of computed iterations. However, unlike it happens with the Fermat test, there are not odd composite numbers that can not be detected with enough iterations of the Solovay-Strassen test.
}
\examples{
## Testing a 32 bits integer using the Miller-Rabin Test
is.primeMR(2845127, iter = 10)

## Testing an object of class vli using the Fermat Test
x <- as.vli("2801401243675128975602569907852141")
is.primeF(x, iter = 100)

## Testing the same object of class vli using the general
##     is.prime function and the Solovay-Strassen Test
is.prime(x, iter = 100, test = "SS")
}
\author{
Javier Leiva Cuadrado
}
