% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Imputation.R
\name{VarSelImputation}
\alias{VarSelImputation}
\title{Imputation of missing values}
\usage{
VarSelImputation(obj, method = "postmean")
}
\arguments{
\item{obj}{an instance of \linkS4class{VSLCMresults} returned by function \link{VarSelCluster}.}

\item{method}{character definiting the method of imputation: "postmean" or "sampling"}
}
\description{
Imputation function based on the mixture model. Two methods can be used: missing values can be 
imputed by their posterior mean (args "postmean") or by a sampling from their full conditionnal
distribution (args "sampling").
}
\examples{
\dontrun{
# Data loading
data("heart")
# Clustering en 2 classes
heart[1,1] <- NA
results <- VarSelCluster(heart[,-13], 2)
# Opening Shiny application to easily see the results
VarSelImputation(results)[1,1]
}

}
