% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotlssVarReg.R
\name{plotlssVarReg}
\alias{plotlssVarReg}
\title{Plots graphics for a location, scale and shape regression model}
\usage{
plotlssVarReg(x, knot.lines = FALSE, xlab = "x", ylab = "y")
}
\arguments{
\item{x}{Object of class lssVarReg (output from \code{\link{lssVarReg}}).}

\item{knot.lines}{Logical to show the knot lines on the graphics (if model is type "semi").
Default is \code{TRUE}}

\item{xlab}{Label to be placed on the x axis of graphics (covariate)}

\item{ylab}{Label to be placed on the y axis of graphics (outcome)}
}
\value{
A graphic is returned, as well as a dataframe. The graphic returned is a 2 by 2 plot of:
\itemize{
\item the mean function over the x-variable, with or without the knot lines indicated
\item the variance function over the x-variable, with or without the knot lines indicated
\item the skew function over the x-variable, with or without the knot lines indicated
\item a Q-Q plot of the squared residuals from the model, plotted against the Chi-squared (df=1)
 distribution. For data from a skew-normal distribution, these residuals should follow a
 Chi-squared (df=1) distribution, regardless of skew.
 }

The dataframe returned contains the following columns:
\itemize{
\item \code{x}: x variable
\item \code{y}: y variable
\item \code{eta}:  (\eqn{\eta}), the location parameter
\item \code{omega}: (\eqn{\omega}), the scale parameter
\item \code{shape}: (\eqn{\nu}),  the shape parameter
\item \code{delta}: (\eqn{\delta}),  a component in the calculations
\item \code{predicted~mean}: (\eqn{\mu}), the mean
\item \code{predicted~variance}: (\eqn{\sigma^2}),  the variance
\item \code{predicted~skewness}: (\eqn{\gamma}),  the skew
\item \code{stand.res2}: the standardised residuals squared.
}
}
\description{
\code{plotlssVarReg} to produce graphics for models fit in the \code{VarReg} package with the
 \code{lssVarReg} function. As the skew-normal function is used to fit this type of model, the data needs
 to be transformed from the SN parameters (location, scale and shape) to the typical mean,
 variance and skew parameters.
}
\examples{
data(mcycle)
## not run. LSS model followed by the basic plot command
##lssmodel<-lssVarReg(mcycle$accel, mcycle$times,  locationmodel="linear", scale2model="linear",
##constantmodel="constant", maxit=10000)
##plotlssVarReg(linmodel, xlab="Time in seconds", ylab="Acceleration")
}
\seealso{
\code{\link{lssVarReg}}
}
