% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{getSSQsweep}
\alias{getSSQsweep}
\title{ANOVA Sum of Squares via Sweeping}
\usage{
getSSQsweep(Data, tobj, random = NULL)
}
\arguments{
\item{Data}{(data.frame) with the data}

\item{tobj}{(terms) object derived from original formula object}

\item{random}{(character) vector, optionally containing information about each
model term, whether it is random or fixed (only used in mixed models)}
}
\value{
(list) representing the  with variables:\cr
\item{aov.tab}{basic ANOVA-table with degrees of freedom (DF), SS and MS}
\item{Lmat}{(list) with components 'Z' and 'A'}
}
\description{
Compute ANOVA Type-1 sum of squares for linear models.
}
\details{
This function performs estimation of ANOVA Type-1 sum of squares
using the SWEEP-operator (see reference), operating on the augmented
matrix \eqn{X'X}, where \eqn{X} represents the design matrix not differentiating
between fixed and random factors. See the numerical example in \code{\link{Fsweep}}
exemplifying the type of augmentation of \eqn{X'X} on which sweeping is carried out.

This is an utility function not intended to be called directly.
For each term in the formula the design-matrix \eqn{Z} is constructed.
Matrix \eqn{X} corresponds to binding all these \eqn{Z}-matrices together column-wise.

Degrees of freedom for each term are determined by subtracting the number of
linearly dependent columns from the total number of column in X asigned to a
specific term.
}
\examples{
\dontrun{
data(dataEP05A2_1)
res <- VCA:::getSSQsweep(dataEP05A2_1, terms(y~day/run))
str(res)
}
}
\references{
Goodnight, J.H., (1979), A Tutorial on the SWEEP Operator, The American Statistician, 33:3, p.149-158
}
\seealso{
\code{\link{Fsweep}}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com},
			Florian Dufey \email{florian.dufey@roche.com}
}
