% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/vca.R
\name{solveMME}
\alias{solveMME}
\title{Solve Mixed Model Equations.}
\usage{
solveMME(obj)
}
\arguments{
\item{obj}{... (VCA) object}
}
\value{
(VCA) object, which has additional elements "RandomEffects" corresponding to the column vector
		   	of estimated random effects, "FixedEffects" being the column vector of estimated fixed effects.
			Element "Matrices" has additional elements referring to the elements of the MMEs and element
			"VarFixed" corresponds to the variance-covariance matrix of fixed effects.
}
\description{
Function solves the Mixed Model Equations (MMEs) to estimate fixed and random effects.
It is for internal use only, thus, not exported.
}
\examples{
\dontrun{
data(dataEP05A2_1)
fit <- anovaVCA(y~day/run, dataEP05A2_1, NegVC=TRUE)
fit <- solveMME(fit)
ranef(fit)
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}

