% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/vca.R
\name{Solve}
\alias{Solve}
\title{Solve System of Linear Equations using Inverse of Cholesky-Root.}
\usage{
Solve(X)
}
\arguments{
\item{X}{(matrix, Matrix) object to be inverted}
}
\value{
(matrix, Matrix) corresponding to the inverse of X
}
\description{
This function is intended to reduce the computational time in function
\code{\link{solveMME}} which computes the inverse of the square variance-
covariance Matrix of observations. It is considerably faster than function
\code{\link{solve}} (see example).
}
\examples{
\dontrun{
# following complex (nonsense) model takes pretty long to fit
system.time(res.sw <- anovaVCA(y~(sample+lot+device)/day/run, VCAdata1))
# extract covariance matrix of observations V
V1 <- getMat(res.sw, "V")
V2 <- as.matrix(V)
system.time(V2i <- solve(V2))
system.time(V1i <- Solve(V))
V1i <- as.matrix(V1i)
dimnames(V1i) <- NULL
dimnames(V2i) <- NULL
all.equal(V1i, V2i)
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}

