% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_BSS_SGL.R
\name{plot_density}
\alias{plot_density}
\title{Function to plot the sparsity levels for estimated model parameters}
\usage{
plot_density(est_mats, threshold = 0.1)
}
\arguments{
\item{est_mats}{A list of numeric matrices, the length of list equals to the number of estimated segments}

\item{threshold}{A numeric value, set as a threshold, the function only counts the non-zeros with absolute
magnitudes larger than threshold}
}
\value{
A plot for sparsity density across over all estimated segments
}
\description{
A function to plot lineplot for sparsity levels of estimated model parameters
}
\examples{
set.seed(1)
est_mats <- list(matrix(rnorm(400, 0, 2), 20, 20), matrix(rnorm(400), 20, 20))
plot_density(est_mats, threshold = 0.25)
}
