% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_Apiladas.R
\name{Plot.Apiladas}
\alias{Plot.Apiladas}
\title{Cree un gráfico de barras apiladas dinámico/estático y flexible}
\usage{
Plot.Apiladas(
  datos,
  ejeX,
  valores,
  categoria,
  ano,
  periodo,
  addPeriodo = FALSE,
  colores,
  titulo = "",
  libreria = c("highcharter", "plotly"),
  estilo = NULL,
  estatico = FALSE
)
}
\arguments{
\item{datos}{Un data frame, no un vector numérico.}

\item{ejeX}{Una variable categórica dentro del data frame ingresado en \code{datos}.}

\item{valores}{Variable numérica que contiene los valores que desea graficar.}

\item{categoria}{Una variable categórica dentro del data frame ingresado en \code{datos}.}

\item{ano}{Argument deprecated. This Argument still exist but will be removed
in the next version.}

\item{periodo}{Argument deprecated. This Argument still exist but will be removed
in the next version.}

\item{addPeriodo}{Argument deprecated. This Argument still exist but will be
removed in the next version.}

\item{colores}{Cadena de caracteres indicando los colores con los cuales se
deben colorear cada una de las series correspondiente a cada nivel del
argumento \code{categoria}. Si no se introduce algún vector se usará la paleta
\code{rainbow} por defecto.}

\item{titulo}{Cadena de caracteres indicando el título principal del plot.}

\item{libreria}{Cadena de caracteres que indica el paquete con el cual se realizará
el plot. Los valores permitidos son \code{"highcharter"} (\emph{valor predeterminado})
y \code{"plotly"}. Los valores se emparejarán parcialmente.}

\item{estilo}{Lista compuesta por varios parámetros, los cuales van a ser
usados para graficar las barras apiladas y cuyo objetivo es personalizar
pequeños detalles de éste.
\itemize{
\item \code{hc.Tema}, \code{hc.Credits}, \code{gg.Tema}, \code{gg.Legend} y \code{gg.Texto}: Igual uso
que en \code{\link[=Plot.Series]{Plot.Series()}}
\item \code{LegendTitle}: Cadena de caracteres indicando un título para la leyenda
(\emph{diferentes niveles del argumento \code{categoria}}).
\item \code{ply.LegendPosition}: Igual uso que en \code{\link[=Plot.Series]{Plot.Series()}}
\item \code{ply.Credits}: Igual uso que en \code{\link[=Plot.Series]{Plot.Series()}}
\item \code{gg.Bar}: Igual uso que en \code{\link[=Plot.Barras]{Plot.Barras()}}
}}

\item{estatico}{Si es \code{FALSE} (\emph{valor predeterminado}) el gráfico a retornar
será dinámico (\emph{dependiendo de la librería seleccionada}), en caso contrario
se retornará un gráfico estático construido con \code{ggplot2}.}
}
\value{
Retorna el diagrama de barras apiladas (\emph{objeto widget de HTML}) creado. La
clase del objeto retornado será un "htmlwidget" y adicionalmente pertenecerá
a la clase "highchart".
}
\description{
Esta función proporciona excelentes herramientas y opciones para la visualización
de un gráfico de barras apiladas con el objetivo de mostrar el tamaño relativo
(\emph{como porcentaje}) de una variable categórica, subdivididas por colores en
función de un subgrupo. Dicha gráfica se va a representar usando la librería
\code{Highcharter}, la cual usa internamente \code{JavaScript}.
}
\section{Lista de argumentos de estilo}{


Sabemos que puede ser abrumador el número de argumentos dentro del parámetro
\code{estilo}, pero es necesario si queremos ofrecer al usuario la máxima
personalización dentro de cada función usando cualquier librería. Por tal
razón, a continuación, se detalla el listado completo de argumentos, usados
al especificar la librería y en qué función están presentes
(\emph{marcado con una × si lo posee}).\tabular{clcccccccc}{
   \strong{Librería} \tab \strong{estilo$} \tab \code{\link[=Plot.Series]{Plot.Series()}} \tab \code{\link[=Plot.Barras]{Plot.Barras()}} \tab \code{\link[=Plot.Apiladas]{Plot.Apiladas()}} \tab \code{\link[=Plot.Boxplot]{Plot.Boxplot()}} \tab \code{\link[=Plot.Radar]{Plot.Radar()}} \tab \code{\link[=Plot.Treemap]{Plot.Treemap()}} \tab \code{\link[=Plot.Torta]{Plot.Torta()}} \tab \code{\link[=Plot.Drilldown]{Plot.Drilldown()}} \cr
   — \tab \emph{gg.Tema} \tab × \tab × \tab × \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Texto} \tab × \tab × \tab × \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Legend} \tab × \tab  \tab × \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Linea} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Punto} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Bar} \tab  \tab × \tab × \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.VarWidth} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.OutShape} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.JitWidth} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.JitSize} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Range} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   \strong{ggplot2} \tab \emph{gg.plty} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.plwd} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.cglwd} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.cglcol} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.fontsize.title} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.fontsize.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.fontcolor.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.border.lwds} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.border.col} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.lowerbound.cex.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.force.print.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   — \tab \emph{gg.overlap.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   » \tab \emph{hc.Tema} \tab × \tab × \tab × \tab × \tab  \tab × \tab × \tab × \cr
   l \tab \emph{hc.Credits} \tab × \tab × \tab × \tab × \tab  \tab × \tab × \tab × \cr
   \strong{highcharter} \tab \emph{hc.BoxInfo} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{hc.Slider} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   » \tab \emph{hc.borderRadius} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   • \tab \emph{ply.Credits} \tab × \tab × \tab × \tab × \tab × \tab × \tab × \tab  \cr
   ° \tab \emph{ply.Legend} \tab  \tab × \tab  \tab  \tab  \tab  \tab × \tab  \cr
   ° \tab \emph{ply.LegendPosition} \tab × \tab  \tab × \tab × \tab × \tab  \tab  \tab  \cr
   \strong{plotly} \tab \emph{ply.Interaction} \tab × \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   ° \tab \emph{ply.Relleno} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   ° \tab \emph{ply.Opacidad} \tab  \tab  \tab  \tab  \tab × \tab × \tab  \tab  \cr
   • \tab \emph{ply.LegendTitle} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   \strong{dygraphs} \tab \emph{dyg.LegendWidth} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   » \tab \emph{dyg.Resaltar} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   — \tab \emph{e.Tema} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{e.Credits} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   \strong{echarts4r} \tab \emph{e.Forma} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{e.LegType} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   — \tab \emph{e.LegLoc} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
}
}

\examples{
\dontshow{if (all(require("tibble"), require("dplyr"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Ejemplo generalizado (sin uso de un consolidado como input)
# library("tibble"); library("dplyr")
set.seed(42)
Blood <- tibble(
  Quarter = sample(c("I", "II", "III", "IV"), size = 200, replace = TRUE),
  Group   = sample(
    c("O", "A", "B", "AB"), size = 200, prob = c(.5, .3, .16, .4), replace = TRUE
  ),
  Prevalence = round(runif(200)*100)
)
Plot.Apiladas(
  datos     = Blood     ,
  ejeX      = Quarter   ,
  valores   = Prevalence,
  categoria = Group     ,
  colores   = c("#FF553D", "#A5FF67", "#40D2FF", "#FFDB5C")
)
\dontshow{\}) # examplesIf}
\dontshow{if (require("dplyr")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# ---------------------------------------------------------------------------
Txt <- "BARRAS APILADAS EN FUNCI\u00d3N DEL NIVEL ACAD\u00c9MICO Y EL A\u00d1O"
Msj <- paste(
  "Se considera \u00fanicamente los valores obtenidos en el primer periodo",
  "acad\u00e9mico de cada a\u00f1o."
)
Plot.Apiladas(
  datos     = ejConsolidadoGrad |> filter(YEAR \%in\% c(2018:2020), SEMESTRE == 1),
  categoria = "NIVEL",      # Pruebe también con alguna de -> unique(ejConsolidadoGrad$Variable)
  colores   = c("#FFA700", "#C10AA1", "#01CDFE", "#00FF44", "#FF0040"),
  titulo    = Txt,
  estilo    = list(LegendTitle = "NIVEL ACAD\u00c9MICO:", hc.Tema = 4, hc.Credits = Msj)
)
Plot.Apiladas(
  datos     = ejConsolidadoGrad |> filter(YEAR \%in\% c(2018:2020), SEMESTRE == 1),
  categoria = "AREAC_SNIES",
    colores   = c("#D2D4DC", "#FF8ABF", "#945BC2", "#D11879",
                  "#FF7F7F", "#FFA568", "#9CFF86", "#89D8FF"),
  titulo    = "BARRAS APILADAS EN FUNCI\u00d3N DEL \u00c1REA DEL SNIES",
  libreria  = "plotly",
  estilo    = list(
    LegendTitle = "NIVEL ACAD\u00c9MICO:",
    ply.Credits = list(x = 0.5, y = 1.5, text = gsub("l p", "l\np", Msj)),
    ply.LegendPosition = list(x = 0.04, y = -0.3, orientation = "h")
  )
)
# Ejemplo usando el caso estático (ggplot2)
Plot.Apiladas(
  datos     = ejConsolidadoGrad |> filter(YEAR \%in\% c(2019:2021), SEMESTRE == 1),
  categoria = "NIVEL",
  colores   = c("#FFA700", "#C10AA1", "#01CDFE", "#00FF44", "#FF0040"),
  titulo    = gsub("L AC", "L\nAC", Txt),
  estatico  = TRUE,
  estilo    = list(
    LegendTitle = "NIVEL ACAD\u00c9MICO:", gg.Tema = 8,
    gg.Legend = list(legend.position = "right", legend.direction = "vertical"),
    gg.Bar    = list(width = 0.6, color = "#000000"),
    gg.Texto  = list(
      subtitle = "\u00bb\u00bb\u00bb", tag = "\u00ae",
      caption  = "Informaci\u00f3n Disponible desde 2009-1"
    )
  )
)
\dontshow{\}) # examplesIf}
}
