% Generated by roxygen2 (4.0.2): do not edit by hand
\name{takeErrorsIntoAccount}
\alias{takeErrorsIntoAccount}
\title{Take Errors Into Account for UPMASK analysis}
\usage{
takeErrorsIntoAccount(originalData, dataIndexes, errorIndexes)
}
\arguments{
\item{originalData}{a data frame to use as the baseline}

\item{dataIndexes}{an array of integers indicating the columns corresponding to the measurements}

\item{errorIndexes}{an array of integers indicating the columns corresponding to the errors}
}
\value{
A data frame with the new values sampled from the error distributions.
}
\description{
Based on a data frame containing measurements and errors, the
\code{takeErrorsIntoAccount} will produce another data frame where each measurement of
the original data frame is replaced by another value taken from a random distribution.
The implemented error model is gaussian, so each value of the output data frame will
be a random sampling from a gaussian distribution where the mean is the value in the
original data frame (indicated by the \code{photometricDataIndexes} column argument)
and the standard deviation is the value from its corresponding error (indicated by the
\code{photometricErrorDataIndexes} column argument). The newly constructed dataframe
is returned by the function.

The user can adapt this function so it can take any error model into account during the
UPMASK analysis.
}
\examples{
# Create a simple data set with the values and errors
toyDataDF <- data.frame(x=runif(10, 0, 10), dx=rep(0.2, 10), y=runif(10, 0, 10),
                        dy=rep(0.1, 10))

# Apply the error models to create another data frame
newToyDataDF <- takeErrorsIntoAccount(toyDataDF, c(1,3), c(2,4))

# Plot the results
plot(toyDataDF$x, toyDataDF$y)
points(newToyDataDF$x, newToyDataDF$y, pch=19, cex=0.8, col="red")

# Clean the environment
rm(list=c("toyDataDF", "newToyDataDF"))
}
\author{
Alberto Krone-Martins, Andre Moitinho
}
\references{
\href{http://dx.doi.org/10.1051/0004-6361/201321143}{Krone-Martins, A. & Moitinho, A., A&A, v.561, p.A57, 2014}
}
\keyword{utilities}

