% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IMU_ActiGraph_Scripts.R
\name{apply_two_regression_hibbing18}
\alias{apply_two_regression_hibbing18}
\title{Apply a Hibbing 2018 two-regression algorithm}
\usage{
apply_two_regression_hibbing18(which_algorithm = data.frame(Wear_Location =
  "Hip", Algorithm = 1), all_data)
}
\arguments{
\item{which_algorithm}{a dataframe specifying which algorithm to use, based on \code{Wear_Location} and \code{Algorithm}}

\item{all_data}{a dataframe providing the processed GT9X data on which to make the predictions}
}
\value{
a numeric vector of predicted energy expenditure values, expressed in metabolic equivalents
}
\description{
Applies the specified two-regression algorithm from \href{https://www.ncbi.nlm.nih.gov/pubmed/29271847}{Hibbing et al. (2018, \emph{Med Sci Sports Exerc})} to data from the primary accelerometer and IMU (if applicable)
}
\examples{
\dontrun{
data(all_data)
process  <-
    data.frame(Wear_Location = "Left Wrist",
        Algorithm = 2,
        stringsAsFactors = FALSE)

TwoRegression:::apply_two_regression_hibbing18(process, all_data)
}
}
\keyword{internal}
