% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bhattacharya.R
\name{Bhattacharya}
\alias{Bhattacharya}
\title{Bhattacharya's method}
\usage{
Bhattacharya(param, n_rnorm = 1000, savePlots = FALSE)
}
\arguments{
\item{param}{a list consisting of following parameters:
\itemize{
  \item \code{midLengths} midpoints of the length class as vector,
  \item \code{catch} a vector with the catch per length class or a matrix with
     catches per length class of subsequent years;
}}

\item{n_rnorm}{number of observations for the function \code{\link{rnorm}}. The
default is 1000.}

\item{savePlots}{logical; indicating whether the analyis graphs should be recorded}
}
\value{
A list with the input parameters and
   \itemize{
   \item \strong{regressionLines} dataframe with intercept, slope, start and end points
      of the regression lines,
   \item \strong{Lmean_SD_list} dataframe with the mean length (Lmean), standard deviation (SD),
     and seperation index (SI) for each cohort,
   \item \strong{bhat_results} dataframe with the results of the Bhattacharya method,
   \item \strong{distributions} list with the x and y values of selected distributions,
   \item \strong{cohort_plots} list with analysis plots (when savePlots = TRUE).
   }
}
\description{
Find relative frequencies and frequency distribution of distinct cohorts
     in the observed length frequency distribution by resolving it into
     Gaussian components.
}
\details{
This method includes the \code{\link{identify}} function, which allows to
     choose points on a graphical device manually. To stop this process please press
     right mouse click on the graph, and in case you are working on a windows
     maschine click on "Stop". An error will be caused if the graphical device
     is closed manually. After you have selected the points for regression analysis
     you will be asked if you want to redo the selection or if you want to continue.
     Please enter in the Console "y" for continuation if you are satisfied
     with your selection and the corresponding Gaussian distribution or enter
     "redo" if you want to repeat the selection procedure. This function
     allows a maximum of 12 cohorts or seperate distributions in one sample. Please
     find more details in the Vignette of this package or in the FAO manual by
     Sparre and Venema (1998) (\strong{Section 3.4.1, p. 80}).
}
\examples{
# The following example requires to choose certain values for the regression analyses:
# first cohort:   point  2 to  8
# second cohort:  point 12 to 17
# third cohort:   point 19 to 23
# fourth cohort:  point 26 to 30

\donttest{
 data(synLFQ1)
 Bhattacharya(param = synLFQ1)
}

}
\references{
Bhattacharya, C.G., 1967. A simple method of resolution of a distribution into Gaussian
components, \emph{Biometrics}, 23:115-135

Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. \emph{FAO Fisheries Technical Paper}, (306.1, Rev. 2). 407 p.
}
\keyword{Bhattacharya}
\keyword{function}
\keyword{length-frequency}
\keyword{lfq}
