% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RadiationPartitioningFunctions.R
\name{partition_solar_radiation}
\alias{partition_solar_radiation}
\title{Diffuse Fraction for Partitioning Solar Radiation}
\usage{
partition_solar_radiation(method, kt, lat = NA, sol.elev = NA)
}
\arguments{
\item{method}{\code{character} method to use for estimating the diffuse fraction, currently available: \code{"Liu_Jordan"}, \code{"Orgill_Hollands"}, \code{"Erbs"}, \code{"Olyphant"}, \code{"Spencer"}, \code{"Reindl-1"}, \code{"Reindl-2"}, \code{"Lam_Li"}.}

\item{kt}{\code{numeric} the clearness index (dimensionless), which is the ratio of the global solar radiation measured at the surface to the total solar radiation at the top of the atmosphere. (0-1)}

\item{lat}{\code{numeric} latitude (degrees). Needed only if method is \code{"Spencer"}.}

\item{sol.elev}{\code{numeric} the solar elevation angles (degrees). Needed only if method is \code{"Reindl-2"}.}
}
\value{
\code{numeric} diffuse fraction.
}
\description{
The function partitions solar radiation (\ifelse{html}{\out{W m<sup>-2</sup>}}{\eqn{W m^-2}{ASCII}}) into direct and diffuse components by estimating the diffuse fraction (k_d). The function uses the models presented in \insertCite{Wong2001;textual}{TrenchR}.
}
\examples{
  partition_solar_radiation(method   = "Erbs", 
                            kt       = 0.5, 
                            lat      = 40, 
                            sol.elev = 60)

}
\references{
\insertAllCited{}
}
\seealso{
Other microclimate functions: 
\code{\link{air_temp_profile_neutral}()},
\code{\link{air_temp_profile_segment}()},
\code{\link{air_temp_profile}()},
\code{\link{degree_days}()},
\code{\link{direct_solar_radiation}()},
\code{\link{diurnal_radiation_variation}()},
\code{\link{diurnal_temp_variation_sineexp}()},
\code{\link{diurnal_temp_variation_sinesqrt}()},
\code{\link{diurnal_temp_variation_sine}()},
\code{\link{monthly_solar_radiation}()},
\code{\link{proportion_diffuse_solar_radiation}()},
\code{\link{solar_radiation}()},
\code{\link{surface_roughness}()},
\code{\link{wind_speed_profile_neutral}()},
\code{\link{wind_speed_profile_segment}()}
}
\concept{microclimate functions}
