% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_files.R
\name{MatrixToPhyDat}
\alias{MatrixToPhyDat}
\alias{PhyDatToMatrix}
\title{Convert between matrices and \code{phyDat} objects}
\usage{
MatrixToPhyDat(tokens)

PhyDatToMatrix(dataset, ambigNA = FALSE, inappNA = ambigNA)
}
\arguments{
\item{tokens}{matrix of tokens, probably created with \code{\link[=ReadCharacters]{ReadCharacters()}}
or \code{\link[=ReadTntCharacters]{ReadTntCharacters()}}. Row names should correspond to tip
labels; column names may optionally correspond to
character labels.}

\item{dataset}{A dataset of class \code{phyDat}.}

\item{ambigNA, inappNA}{Logical specifying whether to denote ambiguous /
inapplicable characters as \code{NA} values.}
}
\value{
\code{MatrixToPhyDat()} returns an object of class \code{phyDat}.

\code{PhyDatToMatrix()} returns a matrix corresponding to the
uncompressed character states within a \code{phyDat} object.
}
\description{
\code{MatrixToPhyDat()} converts a matrix of tokens to a \code{phyDat} object;
\code{PhyDatToMatrix()} converts a \code{phyDat} object to a matrix of tokens.
}
\seealso{
Other phylogenetic matrix conversion functions: 
\code{\link{StringToPhyDat}()}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{phylogenetic matrix conversion functions}
\keyword{internal}
