% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Consensus.R
\name{Consensus}
\alias{Consensus}
\title{Consensus trees}
\usage{
Consensus(trees, p = 1, check.labels = TRUE)
}
\arguments{
\item{trees}{List of trees, optionally of class \code{multiPhylo}.}

\item{p}{Proportion of trees that must contain a split for it to be reported
in the consensus.  \code{p = 0.5} gives the majority-rule consensus; \code{p = 1} (the
default) gives the strict consensus.}

\item{check.labels}{Logical specifying whether to check that all trees have
identical labels.  Defaults to \code{TRUE}, which is slower.}
}
\value{
\code{Consensus()} returns an object of class \code{phylo}, rooted as in the
first entry of \code{trees}.
}
\description{
Calculates the consensus of a set of trees.
}
\examples{
Consensus(as.phylo(0:2, 8))
}
\seealso{
Other consensus tree functions: 
\code{\link{ConsensusWithout}()}

Other tree characterization functions: 
\code{\link{CladisticInfo}()},
\code{\link{Stemwardness}},
\code{\link{TotalCopheneticIndex}()}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{consensus tree functions}
\concept{tree characterization functions}
