% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_analysis.R
\name{TipsInSplits}
\alias{TipsInSplits}
\alias{TipsInSplits.Splits}
\alias{TipsInSplits.phylo}
\alias{SplitImbalance}
\alias{SplitImbalance.Splits}
\alias{SplitImbalance.phylo}
\title{Tips contained within splits}
\usage{
TipsInSplits(splits, keep.names = TRUE, ...)

\method{TipsInSplits}{Splits}(splits, keep.names = TRUE, ...)

\method{TipsInSplits}{phylo}(splits, keep.names = TRUE, ...)

SplitImbalance(splits, keep.names = TRUE, ...)

\method{SplitImbalance}{Splits}(splits, keep.names = TRUE, ...)

\method{SplitImbalance}{phylo}(splits, keep.names = TRUE, ...)
}
\arguments{
\item{splits}{Object of class \code{Splits} or \code{phylo}.}

\item{keep.names}{Logical specifying whether to include the names of \code{splits}
in the output.}

\item{\dots}{Additional parameters to pass to \code{as.Splits()}.}
}
\value{
\code{TipsInSplits()} returns a named vector of integers, specifying the
number of tips contained within each split in \code{splits}.

\code{SplitImbalance()} returns a named vector of integers, specifying the
number of leaves within a split that are not 'balanced' by a leaf outside it;
i.e. a split that divides leaves evenly has an imbalance of zero; one that
splits two tips from ten has an imbalance of 10 - 2 = 8.
}
\description{
\code{TipsInSplits()} specifies the number of tips that occur within each
bipartition split in a \code{Splits} object.
}
\examples{
tree <- PectinateTree(8)
splits <- as.Splits(tree)
TipsInSplits(splits)

plot(tree)
LabelSplits(tree, as.character(splits), frame = 'none', pos = 3L, cex = 0.7)
LabelSplits(tree, TipsInSplits(splits), unit = ' tips', frame = 'none',
            pos = 1L)

}
\seealso{
Other Splits operations: 
\code{\link{LabelSplits}()},
\code{\link{NSplits}()},
\code{\link{NTip}()},
\code{\link{SplitFrequency}()},
\code{\link{SplitsInBinaryTree}()},
\code{\link{TipLabels}()},
\code{\link{as.Splits}()},
\code{\link{match}()}
}
\concept{Splits operations}
