% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_numbering.R
\name{Cladewise}
\alias{Cladewise}
\alias{ApePostorder}
\alias{Postorder}
\alias{PostorderEdges}
\alias{Pruningwise}
\alias{Preorder}
\title{Reorder trees}
\usage{
Cladewise(tree, nTip = NULL, edge = tree$edge)

ApePostorder(tree, nTip = length(tree$tip.label), edge = tree$edge)

Postorder(tree, force = FALSE)

PostorderEdges(edge)

Pruningwise(tree, nTip = length(tree$tip.label), edge = tree$edge)

Preorder(tree)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}.}

\item{nTip}{Integer specifying number of tips (leaves).}

\item{edge}{(optional) the value of tree$edge}

\item{force}{Logical specifying whether to rearrange trees already in
postorder, in order to ensure TreeTools edge ordering.}

\item{edge}{A matrix with two columns, with each row listing the parent and
child node of an edge in a phylogenetic tree.  Property \code{edge} of objects
of class \code{phylo}.}
}
\value{
A tree of class \code{phylo} with nodes following the specified
numbering scheme.
}
\description{
A wrapper for \code{ape:::.reorder_ape}.
Calling this C function directly is approximately twice as fast as using
\code{ape::\link[ape:reorder.phylo]{cladewise}} or
\code{ape::\link[ape:reorder.phylo]{postorder}}
}
\details{
For \code{Cladewise}, \code{Postorder} and \code{Pruningwise}, all nodes must be binary;
\link[ape:collapse.singles]{ape::collapse.singles} and \link[ape:multi2di]{ape::multi2di} may help.

\code{Preorder} is more robust: it supports polytomies, nodes can be numbered
in any sequence, and edges can be listed in any order in the input tree.
It has a unique output for each tree topology, allowing unique trees
to be detected by comparing sorted edge matrices alone.

A tree in preorder is numbered starting from the root node.
Each node is numbered in the sequence in which it is encountered, and
each edge is listed in the sequence in which it is visited.

Child edges of a node are sorted from left to right in order of the
smallest descendant tip; i.e. an edge leading to tip 1 will be to the left
of an edge leading to a subtree that contains tip 2.

Numbering begins by following the leftmost edge of the root node,
and sorting its descendant subtree into preorder.
Then, the next edge at the root node is followed, and its descendants
sorted into preorder, until each edge has been visited.

\code{Postorder} is modified from the ape function to return a specific
order: edges are listed from the node that subtends the smallest
subtree to the one that subtends the largest (i.e. the root node), with
all of a node's descendant edges listed adjacently.  If a tree is already
in postorder, it will not be rearranged unless \code{force = TRUE}, or
\code{PostorderEdges} is employed.
}
\section{Functions}{
\itemize{
\item \code{ApePostorder}: Reorder tree in Postorder using ape's \code{postorder}
function, which is robust to unconventional node numbering

\item \code{Postorder}: Reorder tree in Postorder. Edge lengths are not retained.

\item \code{PostorderEdges}: Reorder edges in Postorder.

\item \code{Pruningwise}: Reorder tree Pruningwise

\item \code{Preorder}: Reorder tree in Preorder (special case of cladewise)
}}

\seealso{
Other C wrappers: \code{\link{Neworder}},
  \code{\link{RenumberTree}}
}
\author{
\code{Preorder} and \code{Postorder}: Martin R. Smith.

\code{Cladewise}, \code{ApePostorder} and \code{Pruningwise}: modified by Martin R. Smith from
\code{.reorder_ape} in \pkg{ape} (Emmanuel Paradis)
}
\concept{C wrappers}
\keyword{internal}
