% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Support.R
\name{SplitFrequency}
\alias{SplitFrequency}
\alias{SplitNumber}
\alias{ForestSplits}
\alias{TreeSplits}
\title{Frequency of splits}
\usage{
SplitFrequency(reference, forest)

SplitNumber(tips, tree, tipIndex, powersOf2)

ForestSplits(forest, powersOf2)

TreeSplits(tree)
}
\arguments{
\item{reference}{A tree of class phylo, or a character vector specifying its splits
(as obtained through \link{Tree2Splits})}

\item{forest}{a list of trees of class phylo, or a multiPhylo object; or a
list of their constituent splits (as obtained through \link{Tree2Splits})}

\item{tips}{Integer vector specifying the tips of the tree within the chosen split}

\item{tree}{A tree of class \code{\link{phylo}}.}

\item{tipIndex}{Character vector of tip names, in a fixed order}

\item{powersOf2}{Integer vector of same length as tipIndex, specifying a power
of 2 to be associated with each tip in turn}
}
\value{
Number of trees in \code{forest} that contain each split in \code{reference}.
if \code{reference} is a tree of class phylo, then the sequence will
correspond to the order of nodes (use `ape::nodelabels to view).
Note that the three nodes at the root of the tree correspond to a
single split; see the example for how these might be plotted on a tree.
}
\description{
\code{SplitFrequency} provides a simple way to count the number of times that
bipartition splits, as defined by a reference tree, occur in a forest of trees.
}
\details{
If multiple calculations are required, some time can be saved by using the
constituent functions (see examples)
}
\section{Functions}{
\itemize{
\item \code{SplitNumber}: Assign a unique integer to each split

\item \code{ForestSplits}: Frequency of splits in a given forest of trees

\item \code{TreeSplits}: Deprecated. Listed the splits in a given tree.
Use Quartet::Tree2Splits instead.
}}

\examples{
{
  library(ape) # for functions rtree & nodelabels
  set.seed(0) # Set seed so random trees are reproducable
  tree1 <- rtree(7)
  tree2 <- rtree(7)
  tree3 <- rtree(7)
  forest <- list(tree1, tree2, tree2, tree3, rtree(7))
  
  # Simple, but means counting each split in the forest twice:
  tree1Freqs <- SplitFrequency(tree1, forest)
  SplitFrequency(tree2, forest)
  
  plot(tree1)
  nodelabels(tree1Freqs, node=as.integer(names(tree1Freqs)))
}

}
\author{
Martin R. Smith
}
