% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculation.R
\name{rdst_MerginePlus}
\alias{rdst_MerginePlus}
\title{Return relative distance between two representative tree rings}
\usage{
rdst_MerginePlus(L, P, yr)
}
\arguments{
\item{L}{is a list of tree rings(x,y coordinates).}

\item{P}{data.frame (x,y,id,yr,r,deg) of radial tree ring points (TR@P)}

\item{yr}{integer of year}
}
\value{
a data frame with relative distance and center angle(degree)
with mergine (-90 - 0 - 360 - 90)
}
\description{
Return relative distance between two representative tree rings
}
\examples{
year.<-73
rdst.<-rdst_MerginePlus(TR@L,TR@P,year.)
plot(rdst.,xlim=c(-200,200),main=year.)
spline<-smooth.spline(rdst.$deg,rdst.$rdst, spar =0.0002)
lines(predict(spline,seq(-202,220,1)),col="red")
}
