% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_methods.R
\name{randomize}
\alias{randomize}
\title{Point sampling algorithm: random sample}
\usage{
randomize(p = 0.5)
}
\arguments{
\item{p}{\code{numeric} - between 0 and 1 - proportion of points to keep.}
}
\description{
This function is meant to be used inside \code{\link{tlsSample}}. It selects points randomly, returning a fraction of the input point cloud.
}
\examples{
file = system.file("extdata", "pine.laz", package="TreeLS")
tls = readTLS(file)
print(tls)

### thin point cloud - note the point count
tls = tlsSample(tls, randomize(0.33))
print(tls)

}
