% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_stats.R
\name{cluster-statistics}
\alias{cluster-statistics}
\alias{SumOfRanges}
\alias{SumOfVariances}
\alias{SumOfVars}
\alias{MeanCentroidDistance}
\alias{MeanCentDist}
\alias{MeanCentroidDist}
\alias{DistanceFromMedian}
\alias{DistFromMed}
\alias{MeanNN}
\alias{MeanMSTEdge}
\title{Cluster size statistics}
\usage{
SumOfRanges(x, cluster = 1)

SumOfVariances(x, cluster = 1)

SumOfVars(x, cluster = 1)

MeanCentroidDistance(x, cluster = 1, Average = mean)

MeanCentDist(x, cluster = 1, Average = mean)

MeanCentroidDist(x, cluster = 1, Average = mean)

DistanceFromMedian(x, cluster = 1, Average = mean)

DistFromMed(x, cluster = 1, Average = mean)

MeanNN(x, cluster = 1, Average = mean)

MeanMSTEdge(x, cluster = 1)
}
\arguments{
\item{x}{Matrix in which each row lists the coordinates of a point
in a Euclidian space; or, where supported, \code{dist} object specifying
distances between each pair of points.}

\item{cluster}{Optional integer vector specifying the cluster or group to
which each row in \code{x} belongs.}

\item{Average}{Function to use to summarize distances. Defaults to \code{mean};
specifying \code{median} returns a value akin to the median absolute divergence
(see \code{\link{mad}}).}
}
\value{
\code{SumOfRanges()} returns a numeric specifying the sum of ranges
within each cluster across all dimensions.

\code{SumOfVariances()} returns a numeric specifying the sum of variances
within each cluster across all dimensions.

\code{MeanCentroidDistance()} returns a numeric specifying the mean
distance from the centroid to points in each cluster.

\code{DistanceFromMedian()} returns a numeric specifying the mean distance
of each point (except the median) from the median point of its cluster.

\code{MeanNN()} returns a numeric specifying the mean distance from each
point within a cluster to its nearest neighbour.

\code{MeanMSTEdge()} returns a numeric specifying the mean length of an
edge in the minimum spanning tree of points within each cluster.
}
\description{
Cluster size statistics
}
\examples{
points <- rbind(matrix(1:16, 4), rep(1, 4), matrix(1:32, 8, 4) / 10)
cluster <- rep(1:3, c(4, 1, 8))

plot(
  points[, 1:2], # Plot first two dimensions of four-dimensional space
  col = cluster, pch = cluster, # Style by cluster membership
  asp = 1, # Fix aspect ratio to avoid distortion
  ann = FALSE, frame = FALSE # Simple axes
)

SumOfRanges(points, cluster)
SumOfVariances(points, cluster)
MeanCentroidDistance(points, cluster)
DistanceFromMedian(points, cluster)
MeanNN(points, cluster)
MeanMSTEdge(points, cluster)
}
\seealso{
Other tree space functions: 
\code{\link{Islands}()},
\code{\link{MSTSegments}()},
\code{\link{MapTrees}()},
\code{\link{MappingQuality}()},
\code{\link{SpectralEigens}()},
\code{\link{median.multiPhylo}()}

Other cluster functions: 
\code{\link{KMeansPP}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{cluster functions}
\concept{tree space functions}
