% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export}
\alias{export}
\title{export}
\usage{
export(andromeda, outputPath, ageWindow = 10, minFreq = 5, archiveName = NULL)
}
\arguments{
\item{andromeda}{(\code{Andromeda::andromeda()})
Andromeda object.}

\item{outputPath}{(\code{character(1)})\cr}

\item{ageWindow}{(\code{integer(1)}: \code{10})\cr
Number of years to bin age groups into.}

\item{minFreq}{(\code{integer(1)}: \code{5})\cr
Minimum frequency required per pathway. Censors data below \code{x} as \verb{<x}. This
minimum value will carry over to the sankey diagram and sunburst plot.}

\item{archiveName}{(\code{character(1)}: \code{NULL})\cr
If not \code{NULL} adds the exported files to a ZIP-file with the specified archive name.}
}
\value{
(\code{invisible(NULL)})
}
\description{
Export andromeda generated by \link[TreatmentPatterns]{computePathways}
object to sharable csv-files and/or a zip archive.
}
\examples{
\donttest{
  ableToRun <- invisible(all(
    require("Eunomia", character.only = TRUE),
    require("CirceR", character.only = TRUE),
    require("CohortGenerator", character.only = TRUE),
    require("dplyr", character.only = TRUE)
  ))
  
  if (ableToRun) {
    # CohortGenerator example
    connectionDetails <- Eunomia::getEunomiaConnectionDetails()
    cdmDatabaseSchema <- "main"
    resultSchema <- "main"
    cohortTable <- "CohortTable"

    cohortsToCreate <- CohortGenerator::createEmptyCohortDefinitionSet()
  
    cohortJsonFiles <- list.files(
      system.file(
        package = "TreatmentPatterns",
        "exampleCohorts"),
        full.names = TRUE)

    for (i in seq_len(length(cohortJsonFiles))) {
      cohortJsonFileName <- cohortJsonFiles[i]
      cohortName <- tools::file_path_sans_ext(basename(cohortJsonFileName))
      cohortJson <- readChar(cohortJsonFileName, file.info(
        cohortJsonFileName)$size)

      cohortExpression <- CirceR::cohortExpressionFromJson(cohortJson)

      cohortSql <- CirceR::buildCohortQuery(
        cohortExpression,
        options = CirceR::createGenerateOptions(generateStats = FALSE))
    
      cohortsToCreate <- rbind(
        cohortsToCreate,
        data.frame(
          cohortId = i,
          cohortName = cohortName,
          sql = cohortSql,
          stringsAsFactors = FALSE))
    }

    cohortTableNames <- CohortGenerator::getCohortTableNames(
      cohortTable = cohortTable)

    CohortGenerator::createCohortTables(
      connectionDetails = connectionDetails,
      cohortDatabaseSchema = resultSchema,
      cohortTableNames = cohortTableNames)

    # Generate the cohorts
    cohortsGenerated <- CohortGenerator::generateCohortSet(
      connectionDetails = connectionDetails,
      cdmDatabaseSchema = cdmDatabaseSchema,
      cohortDatabaseSchema = resultSchema,
      cohortTableNames = cohortTableNames,
      cohortDefinitionSet = cohortsToCreate)
    
    # Select Viral Sinusitis
    targetCohorts <- cohortsGenerated \%>\%
      filter(cohortName == "ViralSinusitis") \%>\%
      select(cohortId, cohortName)

    # Select everything BUT Viral Sinusitis cohorts
    eventCohorts <- cohortsGenerated \%>\%
      filter(cohortName != "ViralSinusitis" & cohortName != "Death") \%>\%
      select(cohortId, cohortName)

    exitCohorts <- cohortsGenerated \%>\%
      filter(cohortName == "Death") \%>\%
      select(cohortId, cohortName)

    cohorts <- dplyr::bind_rows(
      targetCohorts \%>\% mutate(type = "target"),
      eventCohorts \%>\% mutate(type = "event"),
      exitCohorts \%>\% mutate(type = "exit")
    )

    andromeda <- computePathways(
      cohorts = cohorts,
      cohortTableName = cohortTable,
      connectionDetails = connectionDetails,
      cdmSchema = cdmDatabaseSchema,
      resultSchema = resultSchema
    )
    
    try(
      TreatmentPatterns::export(
        andromeda = andromeda,
        outputPath = tempdir(),
        ageWindow = 2,
        minFreq = 5,
        archiveName = "output.zip"
      )
    )
  }
}
}
