% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-fishery-statistics.R
\name{apply_catch_weighting}
\alias{apply_catch_weighting}
\title{Apply catch weighting to data frame}
\usage{
apply_catch_weighting(
  data,
  length_cols,
  catch_col,
  a,
  b,
  parallel = FALSE,
  num_cores = NULL,
  block_size = 10000,
  silence_warnings = TRUE
)
}
\arguments{
\item{data}{Data frame containing length columns and catch data.}

\item{length_cols}{Character vector of length column names.}

\item{catch_col}{Name of the catch column.}

\item{a}{Coefficient of the length-weight relationship.}

\item{b}{Exponent of the length-weight relationship.}

\item{parallel}{Logical. Use parallel processing.}

\item{num_cores}{Number of cores for parallel processing. If NULL, auto-detect.}

\item{block_size}{Block size for parallel processing.}

\item{silence_warnings}{Logical. Suppress warnings.}
}
\value{
Data frame with original columns plus weighted length columns (prefixed with "weighted_").
}
\description{
Applies catch weighting to length frequency columns in a data frame.
Supports parallel processing for large datasets.
}
\examples{
\dontrun{
length_cols <- c("8", "8.5", "9", "9.5", "10", "10.5", "11", "11.5")
weighted_data <- apply_catch_weighting(
  data = fishery_data,
  length_cols = length_cols,
  catch_col = "total_catch",
  a = 0.0001,
  b = 2.984
)
}

}
