% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random-zero-trunc-negative-binomial.R
\name{tidy_zero_truncated_negative_binomial}
\alias{tidy_zero_truncated_negative_binomial}
\title{Tidy Randomly Generated Binomial Distribution Tibble}
\usage{
tidy_zero_truncated_negative_binomial(
  .n = 50,
  .size = 0,
  .prob = 1,
  .num_sims = 1,
  .return_tibble = TRUE
)
}
\arguments{
\item{.n}{The number of randomly generated points you want.}

\item{.size}{Number of trials, zero or more.}

\item{.prob}{Probability of success on each trial 0 <= prob <= 1.}

\item{.num_sims}{The number of randomly generated simulations you want.}

\item{.return_tibble}{A logical value indicating whether to return the result
as a tibble. Default is TRUE.}
}
\value{
A tibble of randomly generated data.
}
\description{
This function will generate \code{n} random points from a zero truncated binomial
distribution with a user provided, \code{.size}, \code{.prob}, and number of
random simulations to be produced. The function returns a tibble with the
simulation number column the x column which corresponds to the n randomly
generated points, the \code{d_}, \code{p_} and \code{q_} data points as well.

The data is returned un-grouped.

The columns that are output are:
\itemize{
\item \code{sim_number} The current simulation number.
\item \code{x} The current value of \code{n} for the current simulation.
\item \code{y} The randomly generated data point.
\item \code{dx} The \code{x} value from the \code{\link[stats:density]{stats::density()}} function.
\item \code{dy} The \code{y} value from the \code{\link[stats:density]{stats::density()}} function.
\item \code{p} The values from the resulting p_ function of the distribution family.
\item \code{q} The values from the resulting q_ function of the distribution family.
}
}
\details{
This function uses the underlying \code{actuar::rztnbinom()}, and its underlying
\code{p}, \code{d}, and \code{q} functions. For more information please see \code{\link[actuar:ZeroTruncatedNegativeBinomial]{actuar::rztnbinom()}}
}
\examples{
tidy_zero_truncated_negative_binomial()

}
\seealso{
\url{https://openacttexts.github.io/Loss-Data-Analytics/ChapSummaryDistributions.html}

Other Discrete Distribution: 
\code{\link{tidy_bernoulli}()},
\code{\link{tidy_binomial}()},
\code{\link{tidy_hypergeometric}()},
\code{\link{tidy_negative_binomial}()},
\code{\link{tidy_poisson}()},
\code{\link{tidy_zero_truncated_binomial}()},
\code{\link{tidy_zero_truncated_poisson}()}

Other Binomial: 
\code{\link{tidy_binomial}()},
\code{\link{tidy_negative_binomial}()},
\code{\link{tidy_zero_truncated_binomial}()},
\code{\link{util_binomial_param_estimate}()},
\code{\link{util_binomial_stats_tbl}()},
\code{\link{util_negative_binomial_param_estimate}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Binomial}
\concept{Discrete Distribution}
\concept{Zero Truncated Negative Distribution}
