% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est-param-normal.R
\name{util_normal_param_estimate}
\alias{util_normal_param_estimate}
\title{Estimate Normal Gaussian Parameters}
\usage{
util_normal_param_estimate(.x, .auto_gen_empirical = TRUE)
}
\arguments{
\item{.x}{The vector of data to be passed to the function.}

\item{.auto_gen_empirical}{This is a boolean value of TRUE/FALSE with default
set to TRUE. This will automatically create the \code{tidy_empirical()} output
for the \code{.x} parameter and use the \code{tidy_combine_distributions()}. The user
can then plot out the data using \verb{$combined_data_tbl} from the function output.}
}
\value{
A tibble/list
}
\description{
The function will return a list output by default, and  if the parameter
\code{.auto_gen_empirical} is set to \code{TRUE} then the empirical data given to the
parameter \code{.x} will be run through the \code{tidy_empirical()} function and combined
with the estimated normal data.

Three different methods of shape parameters are supplied:
\itemize{
\item MLE/MME
\item MVUE
}
}
\details{
This function will attempt to estimate the normal gaussian mean and standard
deviation parameters given some vector of values.
}
\examples{
library(dplyr)
library(ggplot2)

x <- mtcars$mpg
output <- util_normal_param_estimate(x)

output$parameter_tbl

output$combined_data_tbl \%>\%
  tidy_combined_autoplot()

t <- rnorm(50, 0, 1)
util_normal_param_estimate(t)$parameter_tbl

}
\seealso{
Other Parameter Estimation: 
\code{\link{util_beta_param_estimate}()},
\code{\link{util_binomial_param_estimate}()},
\code{\link{util_cauchy_param_estimate}()},
\code{\link{util_exponential_param_estimate}()},
\code{\link{util_gamma_param_estimate}()},
\code{\link{util_geometric_param_estimate}()},
\code{\link{util_hypergeometric_param_estimate}()},
\code{\link{util_logistic_param_estimate}()},
\code{\link{util_lognormal_param_estimate}()},
\code{\link{util_negative_binomial_param_estimate}()},
\code{\link{util_pareto_param_estimate}()},
\code{\link{util_poisson_param_estimate}()},
\code{\link{util_uniform_param_estimate}()},
\code{\link{util_weibull_param_estimate}()}

Other Gaussian: 
\code{\link{tidy_inverse_normal}()},
\code{\link{tidy_normal}()},
\code{\link{util_normal_stats_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Gaussian}
\concept{Parameter Estimation}
