% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow_functions.R
\docType{methods}
\name{plotExposure}
\alias{plotExposure}
\alias{plotExposure,list-method}
\title{Draw an item exposure plot}
\usage{
plotExposure(object, max_rate = 0.25, theta_segment = "Estimated",
  file_pdf = NULL, ...)

\S4method{plotExposure}{list}(object, max_rate = 0.25,
  theta_segment = "Estimated", file_pdf = NULL, ...)
}
\arguments{
\item{object}{An output object generated by \code{\link{Shadow}}.}

\item{max_rate}{A target exposure rate.}

\item{theta_segment}{True or Estimated theta used to create segments ("Estimated" or "True").}

\item{file_pdf}{If supplied a filename, save as a PDF file.}

\item{...}{Additional options to be passed on to \code{pdf()}.}
}
\description{
Draw a plot of item exposure rates
}
\examples{
true_theta <- runif(10, min = -3.5, max = 3.5)
resp_science <- makeTest(itempool_science, info_type = "FISHER", true_theta = true_theta)@data
constraints_science2 <- updateConstraints(constraints_science, off = c(14:20, 32:36))
config_science <- createShadowTestConfig(
  MIP = list(solver = "LPSOLVE"),
  exposure_control = list(method = "ELIGIBILITY")
)
solution <- Shadow(itempool_science, config_science,
  true_theta, constraints_science2, data = resp_science)
p <- plotExposure(solution)

}
