% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tEIG.R
\name{tEIG}
\alias{tEIG}
\title{Tensor Eigenvalue Decomposition Using any Discrete Transform}
\usage{
tEIG(tnsr, tform)
}
\arguments{
\item{tnsr, }{a 3-mode S3 tensor class object (\eqn{n} x \eqn{n} x \eqn{k})}

\item{tform, }{Any discrete transform.

fft: Fast Fourier Transorm

dwt: Discrete Wavelet Transform (Haar Wavelet)

dct: Discrete Cosine transform

dst: Discrete Sine transform

dht: Discrete Hadley transform

dwht: Discrete Walsh-Hadamard transform}
}
\value{
P, a tensor of Eigenvectors (\eqn{n} x \eqn{n} x \eqn{k})

D, a diagonal tensor of Eigenvalues (\eqn{n} x \eqn{n} x \eqn{k})
}
\description{
The Eigenvalue decomposition of a tensor T (\eqn{n} x \eqn{n} x \eqn{k}) decomposes the tensor into
a tensor of eigenvectors (P) and a diagonal tensor of eigenvalues (D) so that
T = P D inv(P).
}
\examples{
T <- t_rand(modes=c(2,2,4))
tEIG(T,"dst")
}
\references{
K. Braman, "Third-order tensors as linear operators on a space of matrices", Linear Algebra and its Applications, vol. 433, no. 7, pp. 1241-1253, 2010.
}
\author{
Kyle Caudle

Randy Hoover

Jackson Cates

Everett Sandbo
}
