% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinalT.R
\name{fit_continuous_tucker}
\alias{fit_continuous_tucker}
\title{Signal tensor estimation from a noisy and incomplete data tensor based on the Tucker model.}
\usage{
fit_continuous_tucker(ttnsr,r,alpha = TRUE)
}
\arguments{
\item{ttnsr}{A given (possibly noisy and incomplete) data tensor.}

\item{r}{A rank to be fitted (Tucker rank).}

\item{alpha}{A signal level

\code{alpha = TRUE} If the signal level is unknown.}
}
\value{
A list containing the following:

\code{C} - An estimated core tensor.

\code{A} - Estimated factor matrices.

\code{iteration} - The number of iterations.

\code{cost} - Log-likelihood value at each iteration.
}
\description{
Estimate a signal tensor from a noisy and incomplete data tensor using the Tucker model.
}
\examples{
# Latent parameters
library(tensorregress)
alpha = 10
A_1 = matrix(runif(10*2,min=-1,max=1),nrow = 10)
A_2 = matrix(runif(10*2,min=-1,max=1),nrow = 10)
A_3 = matrix(runif(10*2,min=-1,max=1),nrow = 10)
C = as.tensor(array(runif(2^3,min=-1,max=1),dim = c(2,2,2)))
theta = ttm(ttm(ttm(C,A_1,1),A_2,2),A_3,3)@data
theta = alpha*theta/max(abs(theta))
adj = mean(theta)
theta = theta-adj
omega = c(-0.2,0.2)+adj

# Observed tensor
ttnsr <- realization(theta,omega)@data

# Estimation of parameters
continuous_est = fit_continuous_tucker(ttnsr,c(2,2,2),alpha = 10)

}
