% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataGen.R
\name{rGenGamma}
\alias{rGenGamma}
\title{Simulation from the Generalized Gamma Distribution}
\usage{
rGenGamma(n, a = 1, b = 1, l = 1, p = 0)
}
\arguments{
\item{n}{Sample size.}

\item{a}{First shape parameter, \eqn{\alpha}.}

\item{b}{Second shape parameter, \eqn{\beta}. For the standard gamma
distribution, set \eqn{\beta=1}.}

\item{l}{Rate.}

\item{p}{Expected censoring proportion.}
}
\value{
Data.frame including the observation times and status indicators.
}
\description{
Generates generalized gamma event times with shape parameters
\eqn{(\alpha,\beta)}, and rate parameter \eqn{\lambda}. See
\code{\link{FitGenGamma}} for the parameterization. If a censoring
proportion \eqn{p} is provided, the event times are subject to
non-informative random right censoring.
}
