% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMST.R
\name{ParaRMST}
\alias{ParaRMST}
\title{Restricted Mean Survival Time}
\usage{
ParaRMST(fit, tau, sig = 0.05)
}
\arguments{
\item{fit}{Fitted parametric survival distribution.}

\item{tau}{Numeric vector of truncation times.}

\item{sig}{Significance level, for CIs.}
}
\value{
Data.frame containing the estimated RMST at each truncation time.
}
\description{
Calculates the RMST as the area under a fitted parametric survival
distribution.
}
\examples{
# Generate Weibull data with 20\% censoring.
data <- GenData(n = 1e3, dist = "weibull", theta = c(2, 0.5), p = 0.2)

# Fit Weibull distribution.
fit <- FitParaSurv(data, dist = "weibull")

# Calculate RMSTs.
rmst <- ParaRMST(fit = fit, tau = c(0.5, 1.0, 1.5, 2.0))

# Generate gamma data with 10\% censoring.
data <- GenData(n = 1e3, dist = "gamma", theta = c(2, 2), p = 0.10)

# Fit gamma distribution.
fit <- FitParaSurv(data, dist = "gamma")

# Calculate RMSTs.
rmst <- ParaRMST(fit = fit, tau = c(0.5, 1.0, 1.5, 2.0))
}
