% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Comparison.R
\name{compParaSurv}
\alias{compParaSurv}
\title{Compare Parametric Survival Distribution}
\usage{
compParaSurv(time, status, arm, dist1 = "weibull", dist0, init1 = NULL,
  init0 = NULL, sig = 0.05, eps = 1e-06, maxit = 10, report = F)
}
\arguments{
\item{time}{Observation time.}

\item{status}{Status indicator, coded as 1 if an event was observed, 0 if
censored.}

\item{arm}{Treatment indicator, coded as 1 for the target group, 0 for the
reference group.}

\item{dist1}{Distribution to fit for the target group. Selected from among:
exp, gamma, gengamma, log-logistic, log-normal, and weibull.}

\item{dist0}{Distribution to fit for the reference group. Same choices as for
the target group. If omitted, defaults to the distribution specified for
the target group.}

\item{init1}{List of initial parameter values for the target group. See
individual distributions for naming convention.}

\item{init0}{List of initial parameter values for the reference group. See
individual distributions for naming convention.}

\item{sig}{Significance level, for CIs.}

\item{eps}{Tolerance for Newton-Raphson iterations.}

\item{maxit}{Maximum number of NR iterations.}

\item{report}{Report fitting progress?}
}
\value{
An object of class \code{contrast} containing the following:
\describe{
  \item{Model1}{The fitted model for the target group.}
  \item{Model0}{The fitted model for the reference group.}
  \item{Contrast}{Contrasts of means and medians.}
}
}
\description{
Compares the means and medians of parametric survival distributions fit to
each of two treatment arms. Available distributions include: exponential,
gamma, generalized gamma, log-logistic, log-normal, and Weibull.
}
\examples{
set.seed(100);
## Weibull and Weibull, different means and medians
# Target group
D1 = rWeibull(n=1e3,a=1,l=1,p=0.2);
D1$arm = 1;
# Reference group
D0 = rWeibull(n=1e3,a=1,l=2,p=0.2);
D0$arm = 0;
# Overall data set
D = rbind(D1,D0);
# Comparison
E = compParaSurv(time=D$time,status=D$status,arm=D$arm,dist1="weibull");

## Gamma and Weibull, different means and medians
# Target group
D1 = rGamma(n=1e3,a=2,l=2,p=0.2);
D1$arm = 1;
# Reference group
D0 = rWeibull(n=1e3,a=2,l=2/sqrt(pi),p=0.2);
D0$arm = 0;
# Overall data set
D = rbind(D1,D0);
# Comparison
E = compParaSurv(time=D$time,status=D$status,arm=D$arm,dist1="gamma",dist0="weibull");

## Weibull and Log-normal, different means, same median
# Target group
D1 = rLogNormal(n=1e3,m=0,s=2,p=0.2);
D1$arm = 1;
# Reference group
D0 = rWeibull(n=1e3,a=2,l=sqrt(log(2)),p=0.2);
D0$arm = 0;
# Overall data set
D = rbind(D1,D0);
# Comparison
E = compParaSurv(time=D$time,status=D$status,arm=D$arm,dist1="log-normal",dist0="weibull");
}
\seealso{
\itemize{
  \item{Fitting function for parametric survival distributions \code{\link{fitParaSurv}}}
}
}
