% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS_extended.R
\name{pGTS}
\alias{pGTS}
\title{Cumulative probability function of the generalized classical tempered stable
(GTS) distribution}
\usage{
pGTS(
  q,
  alphap = NULL,
  alpham = NULL,
  deltap = NULL,
  deltam = NULL,
  lambdap = NULL,
  lambdam = NULL,
  mu = NULL,
  theta = NULL,
  dens_method = "FFT",
  a = -40,
  b = 40,
  nf = 2048,
  ...
)
}
\arguments{
\item{q}{A numeric vector of quantiles.}

\item{alphap, alpham}{Stability parameter. A real number between 0 and 2.}

\item{deltap}{Scale parameter for the right tail. A real number > 0.}

\item{deltam}{Scale parameter for the left tail. A real number > 0.}

\item{lambdap}{Tempering parameter for the right tail. A real number > 0.}

\item{lambdam}{Tempering parameter for the left tail. A real number > 0.}

\item{mu}{A location parameter, any real number.}

\item{theta}{Parameters stacked as a vector.}

\item{dens_method}{A method to get the density function. Here, only "FFT" is
available.}

\item{a}{Starting point of FFT, if \code{dens_method == "FFT"}. -20
by default.}

\item{b}{Ending point of FFT, if \code{dens_method == "FFT"}. 20
by default.}

\item{nf}{Pieces the transformation is divided in. Limited to power-of-two
size.}

\item{...}{Possibility to modify \code{stats::integrate()}.}
}
\value{
As \code{q} is a numeric vector, the return value is also a numeric
vector of probabilities.
}
\description{
The cumulative probability distribution function (CDF) of the generalized
classical tempered stable distribution.
}
\details{
\code{theta} denotes the parameter vector \code{(alphap, alpham, deltap,
deltam, lambdap, lambdam, mu)}. Either provide the parameters individually OR
provide \code{theta}.
The function integrates the PDF numerically with \code{integrate()}.
}
\examples{
\donttest{
x <- seq(-1,1,1)
y <- pGTS(x,0.5,1.5,1,1,1,1,1)
}

}
\seealso{
See also the \code{\link[=dGTS]{dGTS()}} density-function.
}
