% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsample.R
\name{subsample}
\alias{subsample}
\title{subsample}
\usage{
subsample(x, trt = NULL, trt_control = "Control",
  training_fraction = NULL, validation_fraction = NULL,
  test_fraction = NULL, n_samples = 1)
}
\arguments{
\item{x}{<Source data to subsample.}

\item{trt}{Treatment variable. (optional)}

\item{trt_control}{Value for treatment control arm. Defaulte value is
'Control'.}

\item{training_fraction}{Fraction of source data to include in training
subsample.}

\item{validation_fraction}{Fraction of source data to include in validation
subsample.}

\item{test_fraction}{Fraction of source data to include in test subsample.}

\item{n_samples}{Number of subsamples to generate.}
}
\value{
Vector of objects of class Subsample.
}
\description{
Generate a vector of subsamples.
}
\details{
Each subsample will contain training, validation, and test data in
proportions specified by the user. If a treatment variable is supplied the
ratio of treatments will be preserved as closely as possible.
}
\examples{
## Generate example data frame containing response and treatment
N <- 50
x <- data.frame( runif( N ) )
names( x ) <- "response"
x$treatment <- factor( sample( c("Control","Experimental"), size = N,
                       prob = c(0.8,0.2), replace = TRUE ) )

## Generate two subsamples
ex1 <- subsample( x,
                  training_fraction = 0.9,
                  test_fraction = 0.1,
                  n_samples = 2 )

## Generate two subsamples preserving treatment ratio
ex2 <- subsample( x,
                  trt = x$treatment,
                  trt_control = "Control",
                  training_fraction = 0.7,
                  validation_fraction = 0.2,
                  test_fraction = 0.1,
                  n_samples = 2 )
}
\seealso{
\linkS4class{Subsample}
}
