% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSDT_scoring_functions.R
\name{desirable_response_proportion}
\alias{desirable_response_proportion}
\title{desirable_response_proportion}
\usage{
desirable_response_proportion(data, scoring_function_parameters = NULL)
}
\arguments{
\item{data}{data.frame containing response data}

\item{scoring_function_parameters}{named list of scoring function control parameters}
}
\value{
Proportion of (binary) response values that have a desirable value.
The desirable value is 1 if desirable_response = 'increasing' and the
desirable value is 0 if desirable_response = 'decreasing'.
}
\description{
Compute proportion of subjects that have a desirable (binary) response
}
\details{
This function will compute the proportion of subjects for which
the response indicates a desirable response. The response proportion can
be computed for a single treatment arm only (if valued for trt_arm and trt
are provided) or for all data passed to the function.
}
\examples{
N <- 50

data <- data.frame( y = numeric(N),
                    trt = character(N) )

data$y <- sample( c(0,1), size = N, prob = c(0.5,0.5), replace = TRUE )
data$trt <- sample( c('Control','Experimental'), size = N, prob = c(0.4,0.6), replace = TRUE )

## Compute desirable response proportion for all data with increasing
## desirable response (i.e. larger response value is better)
desirable_response_proportion( data, list( desirable_response = 'increasing' ) )
mean( data$y ) # Function return value should match this value

## Compute desirable response proportion for Experimental treatment arm only
## with decreasing desirable response (i.e. smaller response value is better).
desirable_response_proportion( data, list( trt_arm = 'Experimental',
                                           desirable_response = 'decreasing' ) )
}
\seealso{
link{TSDT}, \link{binary_transform}
}
